/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import jakarta.annotation.PostConstruct;
import java.util.List;
import org.alfresco.transform.base.TransformEngine;
import org.alfresco.transform.base.registry.AbstractTransformConfigSource;
import org.alfresco.transform.base.registry.TransformConfigSource;
import org.alfresco.transform.config.TransformConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TransformConfigFromTransformEngines {
    @Autowired(required=false)
    private List<TransformEngine> transformEngines;
    @Autowired
    private List<TransformConfigSource> transformConfigSources;
    @Value(value="${container.isTRouter}")
    private boolean isTRouter;

    @PostConstruct
    public void initTransformEngineConfig() {
        if (this.transformEngines != null) {
            this.transformEngines.stream().forEach(transformEngine -> {
                TransformConfig transformConfig = transformEngine.getTransformConfig();
                if (transformConfig != null) {
                    String engineName = transformEngine.getTransformEngineName();
                    this.transformConfigSources.add(new AbstractTransformConfigSource(engineName, engineName, this.isTRouter ? null : "---", (TransformEngine)transformEngine){
                        final /* synthetic */ TransformEngine val$transformEngine;
                        {
                            this.val$transformEngine = transformEngine;
                            super(sortOnName, readFrom, baseUrl);
                        }

                        @Override
                        public TransformConfig getTransformConfig() {
                            return this.val$transformEngine.getTransformConfig();
                        }
                    });
                }
            });
        }
    }
}

