/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.alfresco.transform.base.CustomTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomTransformers {
    private static final Logger logger = LoggerFactory.getLogger(CustomTransformers.class);
    @Autowired(required=false)
    private List<CustomTransformer> customTransformerList;
    private final Map<String, CustomTransformer> customTransformersByName = new HashMap<String, CustomTransformer>();

    @PostConstruct
    private void initCustomTransformersByName() {
        if (this.customTransformerList != null) {
            this.customTransformerList.forEach(customTransformer -> this.customTransformersByName.put(customTransformer.getTransformerName(), (CustomTransformer)customTransformer));
            List nonNullTransformerNames = this.customTransformerList.stream().map(CustomTransformer::getTransformerName).filter(Objects::nonNull).collect(Collectors.toList());
            if (!nonNullTransformerNames.isEmpty()) {
                logger.info("Custom Transformers:");
                nonNullTransformerNames.stream().sorted().map(name -> "  " + name).forEach(arg_0 -> ((Logger)logger).debug(arg_0));
            }
        }
    }

    public CustomTransformer get(String name) {
        CustomTransformer customTransformer = this.customTransformersByName.get(name);
        return customTransformer == null ? this.customTransformersByName.get(null) : customTransformer;
    }

    public void put(String name, CustomTransformer customTransformer) {
        this.customTransformersByName.put(name, customTransformer);
    }

    public List<CustomTransformer> toList() {
        return this.customTransformerList;
    }
}

