/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.config;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.transform.base.html.TransformInterceptor;
import org.alfresco.transform.base.registry.TransformConfigSource;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.config.CoreFunction;
import org.alfresco.transform.messages.TransformRequestValidator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"org.alfresco.transform"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={".*Test.*"})})
public class WebApplicationConfig
implements WebMvcConfigurer {
    @Value(value="${transform.core.version}")
    private String coreVersionString;
    @Value(value="${container.isTRouter}")
    private boolean isTRouter;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new TransformInterceptor()).addPathPatterns(new String[]{"/transform", "/live", "/ready"});
    }

    @Bean
    public TransformRequestValidator transformRequestValidator() {
        return new TransformRequestValidator();
    }

    @Bean
    public TransformerDebug transformerDebug() {
        return new TransformerDebug().setIsTRouter(this.isTRouter);
    }

    @Bean
    public String coreVersion() {
        return CoreFunction.standardizeCoreVersion((String)this.coreVersionString);
    }

    @Bean
    public List<TransformConfigSource> transformConfigSources() {
        return new ArrayList<TransformConfigSource>();
    }
}

