/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.transform.base.transform.StreamHandler;
import org.alfresco.transform.exceptions.TransformException;
import org.springframework.http.HttpStatus;

public abstract class FragmentHandler
extends StreamHandler {
    private boolean methodHasBeenCall;
    private boolean noMoreFragments;

    protected void initTarget() {
    }

    public OutputStream respondWithFragment(Integer index, boolean finished) throws IOException {
        try {
            if (index == null && !this.methodHasBeenCall) {
                throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "No fragments were produced");
            }
            if (index != null && this.noMoreFragments) {
                throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Final fragment already sent");
            }
            if (index != null) {
                super.handleSuccessfulTransform();
                this.logFragment(index, this.transformManager.getOutputLength());
            }
            this.methodHasBeenCall = true;
            this.noMoreFragments = this.noMoreFragments || index == null || finished;
        }
        catch (Throwable throwable) {
            this.methodHasBeenCall = true;
            this.noMoreFragments = this.noMoreFragments || index == null || finished;
            throw throwable;
        }
        return this.noMoreFragments ? null : this.switchToNewOutputStreamForNewFragment();
    }

    protected void logFragment(Integer index, Long outputLength) {
    }

    @Override
    protected void handleSuccessfulTransform() throws IOException {
        if (!this.methodHasBeenCall) {
            super.handleSuccessfulTransform();
        }
    }

    private OutputStream switchToNewOutputStreamForNewFragment() throws IOException {
        this.transformManager.getOutputStream().close();
        this.transformManager.deleteTargetFile();
        this.initTarget();
        this.setOutputStream();
        return this.outputStream;
    }
}

