/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.logging.LogEntry;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.registry.CustomTransformers;
import org.alfresco.transform.base.transform.FragmentHandler;
import org.alfresco.transform.base.transform.TransformManagerImpl;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.springframework.http.HttpStatus;

abstract class ProcessHandler
extends FragmentHandler {
    private static final List<String> NON_TRANSFORM_OPTION_REQUEST_PARAMETERS = Arrays.asList("sourceExtension", "targetExtension", "targetMimetype", "sourceMimetype", "directAccessUrl", "sourceFilename");
    protected final String sourceMimetype;
    protected final String targetMimetype;
    protected final String sourceFileName;
    private final Map<String, String> transformOptions;
    protected String reference;
    private final TransformServiceRegistry transformRegistry;
    private final TransformerDebug transformerDebug;
    private final ProbeTransform probeTransform;
    private final CustomTransformers customTransformers;

    ProcessHandler(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, String reference, TransformServiceRegistry transformRegistry, TransformerDebug transformerDebug, ProbeTransform probeTransform, CustomTransformers customTransformers) {
        this.sourceMimetype = sourceMimetype;
        this.targetMimetype = targetMimetype;
        this.sourceFileName = transformOptions.getOrDefault("sourceFilename", null);
        this.transformOptions = ProcessHandler.cleanTransformOptions(transformOptions);
        this.reference = reference;
        this.transformRegistry = transformRegistry;
        this.transformerDebug = transformerDebug;
        this.probeTransform = probeTransform;
        this.customTransformers = customTransformers;
    }

    private static Map<String, String> cleanTransformOptions(Map<String, String> requestParameters) {
        HashMap<String, String> transformOptions = new HashMap<String, String>(requestParameters);
        NON_TRANSFORM_OPTION_REQUEST_PARAMETERS.forEach(transformOptions.keySet()::remove);
        transformOptions.values().removeIf(String::isEmpty);
        return transformOptions;
    }

    @Override
    protected void init() throws IOException {
        this.transformManager.setProcessHandler(this);
        super.init();
    }

    public String getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTransformRequest() {
        LogEntry.start();
        this.transformManager.setSourceMimetype(this.sourceMimetype);
        this.transformManager.setTargetMimetype(this.targetMimetype);
        this.transformManager.setSourceFileName(this.sourceFileName);
        this.probeTransform.incrementTransformerCount();
        try {
            this.init();
            long sourceSizeInBytes = this.getSourceSize();
            String transformName = this.getTransformerName(this.sourceMimetype, sourceSizeInBytes, this.targetMimetype, this.transformOptions);
            CustomTransformer customTransformer = this.getCustomTransformer(transformName);
            this.transformerDebug.pushTransform(this.reference, this.sourceMimetype, this.targetMimetype, sourceSizeInBytes, transformName);
            this.transformerDebug.logOptions(this.reference, this.transformOptions);
            this.handleTransform(customTransformer);
        }
        catch (TransformException e) {
            this.transformerDebug.logFailure(this.reference, "  Error: " + e.getMessage());
            LogEntry.setStatusCodeAndMessage(e.getStatus(), e.getMessage());
            this.handleTransformException(e);
        }
        catch (Exception e) {
            this.transformerDebug.logFailure(this.reference, "  Error: " + e.getMessage());
            LogEntry.setStatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            this.handleException(e);
        }
        finally {
            long time = LogEntry.getTransformDuration();
            this.probeTransform.recordTransformTime(time);
            this.transformerDebug.popTransform(this.reference, time);
            LogEntry.complete();
        }
    }

    @Override
    protected void logFragment(Integer index, Long outputLength) {
        this.transformerDebug.logFragment(this.reference, index.intValue(), outputLength.longValue());
    }

    @Override
    public void transform(CustomTransformer customTransformer) throws Exception {
        customTransformer.transform(this.sourceMimetype, this.inputStream, this.targetMimetype, this.outputStream, this.transformOptions, this.transformManager);
    }

    protected abstract long getSourceSize();

    @Override
    public void onSuccessfulTransform() {
        this.sendTransformResponse(this.transformManager);
        LogEntry.setTargetSize(this.transformManager.getOutputLength());
        LogEntry.setStatusCodeAndMessage(HttpStatus.OK, "Success");
    }

    protected void sendTransformResponse(TransformManagerImpl transformManager) {
    }

    protected void handleTransformException(TransformException e) {
        throw e;
    }

    protected void handleException(Exception e) {
        throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
    }

    private String getTransformerName(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> transformOptions) {
        String transformerName = this.transformRegistry.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, transformOptions, null);
        if (transformerName == null) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "No transforms for: " + sourceMimetype + (String)(sourceSizeInBytes >= 0L ? " (" + TransformerDebug.fileSize((long)sourceSizeInBytes) + ")" : "") + " -> " + targetMimetype + transformOptions.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ", " ", "")));
        }
        return transformerName;
    }

    private CustomTransformer getCustomTransformer(String transformName) {
        CustomTransformer customTransformer = this.customTransformers.get(transformName);
        if (customTransformer == null) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Custom Transformer " + transformName + " not found");
        }
        return customTransformer;
    }
}

