/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithTwoCustomTransformers;
import org.alfresco.transform.base.fakes.FakeTransformerPdf2Png;
import org.alfresco.transform.base.fakes.FakeTransformerTxT2Pdf;
import org.alfresco.transform.base.registry.TransformConfigFiles;
import org.alfresco.transform.base.registry.TransformConfigFromFiles;
import org.alfresco.transform.base.registry.TransformRegistry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.util.ReflectionTestUtils;

@AutoConfigureMockMvc
@SpringBootTest(classes={Application.class}, properties={"transform.engine.config.cron=*/1 * * * * *"})
@ContextConfiguration(classes={FakeTransformEngineWithTwoCustomTransformers.class, FakeTransformerTxT2Pdf.class, FakeTransformerPdf2Png.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class TransformRegistryRefreshTest {
    @SpyBean(proxyTargetAware=false)
    private TransformRegistry transformRegistry;
    @Autowired
    private TransformConfigFromFiles transformConfigFromFiles;
    @Autowired
    private TransformConfigFiles transformConfigFiles;

    @Test
    public void checkRegistryRefreshes() throws InterruptedException {
        this.waitForRegistryReady();
        Assertions.assertEquals((int)4, (int)this.transformRegistry.getTransformConfig().getTransformers().size());
        this.transformRegistry.retrieveConfig();
        ReflectionTestUtils.setField((Object)this.transformConfigFiles, (String)"files", (Object)ImmutableMap.of((Object)"a", (Object)"config/addA2B.json", (Object)"foo", (Object)"config/addB2C.json"));
        this.transformConfigFromFiles.initFileConfig();
        Awaitility.await().pollDelay(3L, TimeUnit.SECONDS).until(() -> {
            this.transformRegistry.retrieveConfig();
            Assertions.assertEquals((int)6, (int)this.transformRegistry.getTransformConfig().getTransformers().size());
            return true;
        });
    }

    private void waitForRegistryReady() throws InterruptedException {
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).pollDelay(Duration.ZERO).until(() -> this.transformRegistry.isReadyForTransformRequests());
    }
}

