/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.transform.base.clients.FileInfo;
import org.alfresco.transform.base.clients.HttpClient;
import org.junit.jupiter.api.Assertions;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class AbstractMetadataExtractsIT {
    private static final String ENGINE_URL = "http://localhost:8090";
    private static final String targetMimetype = "alfresco-metadata-extract";
    private static final String targetExtension = "json";
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    public void testTransformation(FileInfo fileInfo) {
        String sourceMimetype = fileInfo.getMimeType();
        String sourceFile = fileInfo.getPath();
        String descriptor = MessageFormat.format("Transform ({0}, {1} -> {2}, {3})", sourceFile, sourceMimetype, targetMimetype, targetExtension);
        try {
            ResponseEntity<Resource> response = HttpClient.sendTRequest(ENGINE_URL, sourceFile, sourceMimetype, targetMimetype, targetExtension);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)descriptor);
            String metadataFilename = sourceFile + "_metadata.json";
            Map<String, Serializable> actualMetadata = this.readMetadata(((Resource)response.getBody()).getInputStream());
            File actualMetadataFile = new File(metadataFilename);
            this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValue(actualMetadataFile, actualMetadata);
            Map<String, Serializable> expectedMetadata = this.readExpectedMetadata(metadataFilename, actualMetadataFile);
            Assertions.assertEquals(expectedMetadata, actualMetadata, (String)(sourceFile + ": The metadata did not match the expected value. It has been saved in " + actualMetadataFile.getAbsolutePath()));
            actualMetadataFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)(descriptor + " exception: " + e.getMessage()));
        }
    }

    private Map<String, Serializable> readExpectedMetadata(String filename, File actualMetadataFile) throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            if (inputStream == null) {
                Assertions.fail((String)("The expected metadata file " + filename + " did not exist.\nThe actual metadata has been saved in " + String.valueOf(actualMetadataFile.getAbsoluteFile())));
            }
            Map<String, Serializable> map = this.readMetadata(inputStream);
            return map;
        }
    }

    private Map<String, Serializable> readMetadata(InputStream inputStream) throws IOException {
        TypeReference<HashMap<String, Serializable>> typeRef = new TypeReference<HashMap<String, Serializable>>(){};
        return (Map)this.jsonObjectMapper.readValue(inputStream, (TypeReference)typeRef);
    }
}

