/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.transform.base.AbstractBaseTest;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.TransformController;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithTwoCustomTransformers;
import org.alfresco.transform.base.fakes.FakeTransformerPdf2Png;
import org.alfresco.transform.base.fakes.FakeTransformerTxT2Pdf;
import org.alfresco.transform.base.model.FileRefEntity;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.sfs.SharedFileStoreClient;
import org.alfresco.transform.base.transform.TransformHandler;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.config.TransformConfig;
import org.codehaus.plexus.util.FileUtils;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.multipart.MultipartFile;

@AutoConfigureMockMvc
@SpringBootTest(classes={Application.class})
@ContextConfiguration(classes={FakeTransformEngineWithTwoCustomTransformers.class, FakeTransformerTxT2Pdf.class, FakeTransformerPdf2Png.class})
public class TransformControllerTest {
    @Autowired
    private MockMvc mockMvc;
    @Autowired
    private TransformController transformController;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    private String coreVersion;
    @TempDir
    public File tempDir;
    @MockBean
    protected SharedFileStoreClient fakeSfsClient;

    static void resetProbeForTesting(TransformController transformController) {
        AbstractBaseTest.resetProbeForTesting(transformController.getProbeTransform());
    }

    @Test
    public void testInitEngine() throws Exception {
        Assertions.assertEquals((Object)FakeTransformEngineWithTwoCustomTransformers.class.getSimpleName(), (Object)this.transformController.transformEngine.getClass().getSimpleName());
    }

    @Test
    public void testStartupLogsIncludeEngineMessages() {
        StringJoiner controllerLogMessages = TransformControllerTest.getLogMessagesFor(TransformController.class);
        this.transformController.startup();
        Assertions.assertEquals((Object)"--------------------------------------------------------------------------------------------------------------------------------------------------------------\nStartup 0000 TwoCustomTransformers\nLine 2 0000 TwoCustomTransformers\nLine 3\n--------------------------------------------------------------------------------------------------------------------------------------------------------------\nStarting application components... Done", (Object)controllerLogMessages.toString());
    }

    public static StringJoiner getLogMessagesFor(Class classBeingLogged) {
        final StringJoiner logMessages = new StringJoiner("\n");
        Logger logger = (Logger)LoggerFactory.getLogger((Class)classBeingLogged);
        AppenderBase<ILoggingEvent> logAppender = new AppenderBase<ILoggingEvent>(){

            protected void append(ILoggingEvent iLoggingEvent) {
                logMessages.add(iLoggingEvent.getMessage());
            }
        };
        logAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        logger.setLevel(Level.DEBUG);
        logger.addAppender((Appender)logAppender);
        logAppender.start();
        return logMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPageWithOrWithoutIngresPrefix(String url, boolean behindIngres, String ... expected) throws Exception {
        boolean origBehindIngres = (Boolean)ReflectionTestUtils.getField((Object)this.transformController, (String)"behindIngres");
        try {
            ReflectionTestUtils.setField((Object)this.transformController, (String)"behindIngres", (Object)behindIngres);
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[0]))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[1]))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[2]))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[3]))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[4]))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)expected[5])));
        }
        finally {
            ReflectionTestUtils.setField((Object)this.transformController, (String)"behindIngres", (Object)origBehindIngres);
        }
    }

    @Test
    public void testVersionEndpointIncludesAvailable() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/version", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("TwoCustomTransformers " + this.coreVersion));
    }

    @Test
    public void testRootEndpointReturnsTestPage() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/", false, "TwoCustomTransformers Test Page", "action=\"/test\"", "<a href=\"/log\">Log</a>", "<a href=\"/ready\">Ready</a>", "<a href=\"/live\">Live</a>", "<a href=\"/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testRootEndpointReturnsTestPageWithIngres() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/", true, "TwoCustomTransformers Test Page", "action=\"/twocustomtransformers/test\"", "href=\"/twocustomtransformers/log\"", "<a href=\"/twocustomtransformers/ready\">Ready</a>", "<a href=\"/twocustomtransformers/live\">Live</a>", "<a href=\"/twocustomtransformers/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testErrorEndpointReturnsErrorPage() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/error", false, "TwoCustomTransformers Error Page", "<a href=\"/\">Test</a>", "<a href=\"/log\">Log</a>", "<a href=\"/ready\">Ready</a>", "<a href=\"/live\">Live</a>", "<a href=\"/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testErrorEndpointReturnsErrorPageWithIngres() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/error", true, "TwoCustomTransformers Error Page", "href=\"/twocustomtransformers/\"", "href=\"/twocustomtransformers/log\"", "<a href=\"/twocustomtransformers/ready\">Ready</a>", "<a href=\"/twocustomtransformers/live\">Live</a>", "<a href=\"/twocustomtransformers/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testLogEndpointReturnsLogPage() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/log", false, "TwoCustomTransformers Log Entries", "<a href=\"/\">Test</a>", "Log", "<a href=\"/ready\">Ready</a>", "<a href=\"/live\">Live</a>", "<a href=\"/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testLogEndpointReturnsLogPageWithIngres() throws Exception {
        this.testPageWithOrWithoutIngresPrefix("/log", true, "TwoCustomTransformers Log Entries", "href=\"/twocustomtransformers/\"", "Log", "<a href=\"/twocustomtransformers/ready\">Ready</a>", "<a href=\"/twocustomtransformers/live\">Live</a>", "<a href=\"/twocustomtransformers/transform/config?configVersion=9999\">Config</a>");
    }

    @Test
    public void testReadyEndpointReturnsSuccessful() throws Exception {
        TransformControllerTest.resetProbeForTesting(this.transformController);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/ready", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"Success - ")));
    }

    @Test
    public void testLiveEndpointReturnsSuccessful() throws Exception {
        TransformControllerTest.resetProbeForTesting(this.transformController);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/live", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"Success - ")));
    }

    @Test
    public void testLiveEndpointReturnsErrorAfterTooManyTransforms() throws Exception {
        TransformControllerTest.resetProbeForTesting(this.transformController);
        ProbeTransform probeTransform = this.transformController.getProbeTransform();
        IntStream.range(0, 1025).forEach(i -> probeTransform.incrementTransformerCount());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/live", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.TOO_MANY_REQUESTS.value())).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"Transformer requested to die. It has performed more than 1024 transformations")));
    }

    @Test
    public void testConfigEndpointReturnsOriginalConfigFormat() throws Exception {
        TransformControllerTest.assertConfig("/transform/config", "Pdf2Png,null,imageOptions\nTxT2Pdf,null,docOptions\nTxt2JpgViaPdf,null,imageOptions\nTxt2PngViaPdf,null,imageOptions", "docOptions,imageOptions", this.mockMvc, this.objectMapper);
    }

    @Test
    public void testConfigLatestEndpointReturnsCoreVersionAndDirectAccessUrlOption() throws Exception {
        TransformControllerTest.assertConfig("/transform/config?configVersion=2", "Pdf2Png," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename\nTxT2Pdf," + this.coreVersion + ",directAccessUrl,docOptions,sourceFilename\nTxt2JpgViaPdf,null,imageOptions\nTxt2PngViaPdf," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename", "directAccessUrl,docOptions,imageOptions,sourceFilename", this.mockMvc, this.objectMapper);
    }

    static void assertConfig(String url, String expectedTransformers, String expectedOptions, MockMvc mockMvc, ObjectMapper objectMapper) throws Exception {
        TransformConfig config = (TransformConfig)objectMapper.readValue(mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString(), TransformConfig.class);
        Assertions.assertEquals((Object)expectedTransformers, (Object)config.getTransformers().stream().map(t -> t.getTransformerName() + "," + t.getCoreVersion() + "," + t.getTransformOptions().stream().sorted().collect(Collectors.joining(","))).sorted().collect(Collectors.joining("\n")));
        Assertions.assertEquals((Object)expectedOptions, (Object)config.getTransformOptions().keySet().stream().sorted().collect(Collectors.joining(",")));
    }

    @Test
    public void testTransformEndpointThatUsesTransformRequests() throws Exception {
        HashMap sfsRef2File = new HashMap();
        Mockito.when((Object)this.fakeSfsClient.saveFile((File)ArgumentMatchers.any())).thenAnswer(invocation -> {
            File originalFile = (File)invocation.getArguments()[0];
            File fileCopy = new File(this.tempDir, originalFile.getName() + "copy");
            FileUtils.copyFile((File)originalFile, (File)fileCopy);
            String fileRef = UUID.randomUUID().toString();
            sfsRef2File.put(fileRef, fileCopy);
            return new FileRefResponse(new FileRefEntity(fileRef));
        });
        Mockito.when((Object)this.fakeSfsClient.retrieveFile((String)ArgumentMatchers.any())).thenAnswer(invocation -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename*=UTF-8''transform.tmp"})).body((Object)new UrlResource(((File)sfsRef2File.get(invocation.getArguments()[0])).toURI())));
        File sourceFile = AbstractBaseTest.getTestFile("original.txt", true, this.tempDir);
        String sourceFileRef = this.fakeSfsClient.saveFile(sourceFile).getEntry().getFileRef();
        TransformRequest transformRequest = TransformRequest.builder().withRequestId("1").withSchema(1).withClientData("Alfresco Digital Business Platform").withSourceReference(sourceFileRef).withSourceMediaType("text/plain").withSourceSize(Long.valueOf(sourceFile.length())).withTargetMediaType("application/pdf").withInternalContextForTransformEngineTests().build();
        String transformRequestJson = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformReplyJson = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"}).header("Content-Type", new Object[]{"application/json"}).content(transformRequestJson)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.CREATED.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformReplyJson, TransformReply.class);
        String newValue = new String(((Resource)this.fakeSfsClient.retrieveFile(transformReply.getTargetReference()).getBody()).getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)transformRequest.getRequestId(), (Object)transformReply.getRequestId());
        Assertions.assertEquals((Object)transformRequest.getClientData(), (Object)transformReply.getClientData());
        Assertions.assertEquals((int)transformRequest.getSchema(), (int)transformReply.getSchema());
        Assertions.assertEquals((Object)"Original Text -> TxT2Pdf()", (Object)newValue);
    }

    @Test
    public void testTransformEndpointThatUploadsAndDownloadsContent() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8))).param("sourceMimetype", new String[]{"text/plain"}).param("targetMimetype", new String[]{"application/pdf"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform.pdf")).andExpect(MockMvcResultMatchers.content().string("Start -> TxT2Pdf(page=1)"));
    }

    @Test
    public void testTestTransformEndpointWhichConvertsRequestParameters() throws Exception {
        TransformHandler transformHandlerOrig = this.transformController.transformHandler;
        try {
            TransformHandler transformHandlerSpy;
            this.transformController.transformHandler = transformHandlerSpy = (TransformHandler)Mockito.spy((Object)transformHandlerOrig);
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/test", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8))).param("sourceMimetype", new String[]{"image/bmp"}).param("_sourceMimetype", new String[]{"text/plain"}).param("targetMimetype", new String[]{"application/pdf"}).param("_targetMimetype", new String[]{""}).param("page", new String[]{"replaced"}).param("name1", new String[]{"hasNoValueSoRemoved"}).param("value1", new String[]{""}).param("name2", new String[]{"page"}).param("value2", new String[]{"1"}).param("name3", new String[]{"sourceEncoding"}).param("value3", new String[]{"UTF-8"}));
            ((TransformHandler)Mockito.verify((Object)transformHandlerSpy)).handleHttpRequest((HttpServletRequest)ArgumentMatchers.any(), (MultipartFile)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"text/plain"), (String)ArgumentMatchers.eq((Object)"application/pdf"), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"sourceMimetype", (Object)"text/plain", (Object)"targetMimetype", (Object)"application/pdf", (Object)"page", (Object)"1", (Object)"sourceEncoding", (Object)"UTF-8")), (ProbeTransform)ArgumentMatchers.any());
        }
        finally {
            this.transformController.transformHandler = transformHandlerOrig;
        }
    }

    @Test
    public void testInterceptOfMissingServletRequestParameterException() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8)))).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Request parameter 'sourceMimetype' is missing")));
    }

    @Test
    public void testInterceptOfTransformException_noTransformers() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8))).param("sourceMimetype", new String[]{"text/plain"}).param("targetMimetype", new String[]{"application/pdf"}).param("unknown", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"TwoCustomTransformers Error Page"))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"No transforms for: text/plain (5 bytes) -&gt; application/pdf unknown=1")));
    }
}

