---
title: Secrets
---

# Secrets

This page describe how secrets are securely managed in our playbook. It also
serves as a comprehensive list of credentials in case you want to populated
them manually.

Links to the official documentation relevant for this subject:

* [Alfresco Authorization][security]

## Secrets defined as variables

### activemq_password

The password used to access the activemq instance.

### repo_db_password

The password used to access the postgres database of Repository

### sync_db_password

The password used to access the postgres database of Sync

### reposearch_shared_secret

The secret used between Solr and Repository for communicating.

### elasticsearch_password

The password to use to authentication to the Elasticsearch server.

### ca_signing_key_passphrase

The playbook will **always** try to generate a certificate & key pair for each
host of the inventory. This secret holds the passphrase to use for the CA
signing key, whether it is generated by the playbook or it is provided by user
as an input.

### certs_p12_passphrase

Generated certificates and keys are contained in a PKCS12 container which needs
a passphrase to be read. This secret holds this passphrase.

### identity_admin_password

The password to use to login in the Keycloak console (master realm) with the
default `admin` user.

## Secrets not yet handled

The `repository_acs_environment` ansible variable holds environment variables for the JVM
that must be handled as secrets:

```yml
repository_acs_environment:
  JAVA_TOOL_OPTIONS:
    - -Dmetadata-keystore.password=<your-keystore-password>
    - -Dmetadata-keystore.metadata.password=<your-keystore-password>
```

`metadata-keystore.password` is the same variable handled in `keystore_password`.

`metadata-keystore.metadata.password` is the password of the keystore dedicated to repository metadata.

[security]: https://support.hyland.com/r/Alfresco/Alfresco-Content-Services/25.1/Alfresco-Content-Services/Administer/Manage-Security/Authorization
