/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starter.rb.configuration;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFF)
public class ActivitiAuditProducerEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ActivitiAuditProducerEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Optional<Boolean> isPartitioned = Optional.ofNullable((Boolean)environment.getProperty("activiti.cloud.messaging.partitioned", Boolean.class));
        logger.warn("Configuring activiti.cloud.messaging.partitioned={}", isPartitioned);
        Integer partitionCount = (Integer)environment.getProperty("activiti.cloud.messaging.partition-count", Integer.class);
        isPartitioned.filter(Boolean.TRUE::equals).ifPresent(value -> {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("spring.cloud.stream.bindings.auditProducer.producer.partitionKeyExtractorName", "activitiAuditProducerPartitionKeyExtractor");
            properties.put("spring.cloud.stream.bindings.auditProducer.producer.partitionCount", partitionCount);
            environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource(ActivitiAuditProducerEnvironmentPostProcessor.class.getSimpleName(), properties));
        });
    }
}

