/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.channels;

import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.connectors.starter.channels.IntegrationErrorChannelResolver;
import org.activiti.cloud.connectors.starter.channels.IntegrationErrorSender;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class IntegrationErrorSenderImpl
implements IntegrationErrorSender {
    private final StreamBridge streamBridge;
    private final IntegrationErrorChannelResolver resolver;

    public IntegrationErrorSenderImpl(StreamBridge streamBridge, IntegrationErrorChannelResolver resolver) {
        this.streamBridge = streamBridge;
        this.resolver = resolver;
    }

    @Override
    public void send(Message<IntegrationError> message) {
        IntegrationRequest request = ((IntegrationError)message.getPayload()).getIntegrationRequest();
        String destination = this.resolver.resolveDestination(request);
        this.streamBridge.send(destination, (Object)MessageBuilder.fromMessage(message).setHeader("spring.cloud.function.destination", (Object)destination).build());
    }
}

