/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.channels;

import java.util.Optional;
import java.util.function.Predicate;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.connectors.starter.channels.IntegrationResultDestinationBuilder;
import org.activiti.cloud.connectors.starter.configuration.ConnectorProperties;
import org.springframework.util.ObjectUtils;

public class IntegrationResultDestinationBuilderImpl
implements IntegrationResultDestinationBuilder {
    private final ConnectorProperties connectorProperties;

    public IntegrationResultDestinationBuilderImpl(ConnectorProperties connectorProperties) {
        this.connectorProperties = connectorProperties;
    }

    @Override
    public String buildDestination(IntegrationRequest event) {
        String resultDestinationOverride = this.connectorProperties.getResultDestinationOverride();
        String destination = ObjectUtils.isEmpty((Object)resultDestinationOverride) ? Optional.of(event).map(IntegrationRequest::getResultDestination).filter(Predicate.not(ObjectUtils::isEmpty)).orElseGet(() -> this.getServiceDestination(event)) : resultDestinationOverride;
        return destination;
    }

    protected String getServiceDestination(IntegrationRequest event) {
        return "integrationResult" + this.connectorProperties.getMqDestinationSeparator() + event.getServiceFullName();
    }
}

