/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.asserts;

import java.io.IOException;
import org.activiti.cloud.services.common.file.FileContent;
import org.activiti.cloud.services.test.asserts.AssertZipContent;
import org.assertj.core.api.Assertions;

public class AssertFileContent {
    private final FileContent fileContent;

    public AssertFileContent(FileContent fileContent) {
        this.fileContent = fileContent;
    }

    public AssertZipContent isZip() {
        Assertions.assertThat((Object)this.fileContent).isNotNull();
        Assertions.assertThat((String)this.fileContent.getContentType()).isEqualTo("application/zip");
        try {
            return new AssertZipContent(this.fileContent);
        }
        catch (IOException e) {
            Assertions.fail((String)"Provided file content is not zip");
            return null;
        }
    }

    public AssertFileContent hasName(String expectedName) {
        Assertions.assertThat((Object)this.fileContent).isNotNull();
        Assertions.assertThat((String)this.fileContent.getFilename()).isEqualTo(expectedName);
        return this;
    }

    public AssertFileContent hasContentType(String expectedContentType) {
        Assertions.assertThat((Object)this.fileContent).isNotNull();
        Assertions.assertThat((String)this.fileContent.getContentType()).isEqualTo(expectedContentType);
        return this;
    }

    public AssertFileContent hasContent(byte[] expectedContent) {
        this.hasContent(new String(expectedContent));
        return this;
    }

    public AssertFileContent hasContent(String expectedContent) {
        Assertions.assertThat((Object)this.fileContent).isNotNull();
        Assertions.assertThat((byte[])this.fileContent.getFileContent()).isNotNull();
        Assertions.assertThat((String)new String(this.fileContent.getFileContent())).isEqualTo(expectedContent);
        return this;
    }

    public static AssertFileContent assertThatFileContent(FileContent fileContent) {
        return new AssertFileContent(fileContent);
    }
}

