/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.activiti.cloud.services.test.identity.IdentityTokenProducer;
import org.activiti.cloud.services.test.identity.interceptor.IdentityTokenInterceptor;
import org.activiti.cloud.services.test.identity.keycloak.KeycloakTokenProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@AutoConfiguration
@AutoConfigureBefore(value={RestTemplateAutoConfiguration.class})
public class TestConfiguration {
    private final List<Module> modules;

    public TestConfiguration(List<Module> modules) {
        this.modules = modules;
    }

    @Bean
    @ConditionalOnMissingBean
    public IdentityTokenProducer keycloakTokenProducer(@Value(value="${keycloak.auth-server-url:}") String authServerUrl, @Value(value="${keycloak.realm:}") String realm) {
        return new KeycloakTokenProducer(authServerUrl, realm);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"identity.test.token-interceptor.enabled"}, havingValue="true", matchIfMissing=true)
    public IdentityTokenInterceptor identityTokenInterceptor(IdentityTokenProducer keycloakTokenProducer) {
        return new IdentityTokenInterceptor(keycloakTokenProducer);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateBuilder restTemplateBuilder(@Autowired(required=false) IdentityTokenInterceptor identityTokenInterceptor) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new Jackson2HalModule());
        for (Module module : this.modules) {
            if (!module.getModuleName().startsWith("map")) continue;
            mapper.registerModule(module);
        }
        MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        jackson2HttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON, MediaType.APPLICATION_JSON));
        jackson2HttpMessageConverter.setObjectMapper(mapper);
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalMessageConverters(new HttpMessageConverter[]{jackson2HttpMessageConverter, new StringHttpMessageConverter(StandardCharsets.UTF_8), new ByteArrayHttpMessageConverter()});
        if (identityTokenInterceptor != null) {
            return restTemplateBuilder.additionalInterceptors(new ClientHttpRequestInterceptor[]{identityTokenInterceptor});
        }
        return restTemplateBuilder;
    }
}

