/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starters.test.builder;

import java.util.Date;
import java.util.UUID;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.impl.TaskCandidateGroupImpl;
import org.activiti.api.task.model.impl.TaskCandidateUserImpl;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.api.task.model.impl.QueryCloudTaskImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskAssignedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCancelledEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateGroupAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateUserAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCompletedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCreatedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskUpdatedEventImpl;
import org.activiti.cloud.starters.test.EventsAggregator;

public class TaskEventContainedBuilder {
    private EventsAggregator eventsAggregator;

    public TaskEventContainedBuilder(EventsAggregator eventsAggregator) {
        this.eventsAggregator = eventsAggregator;
    }

    public Task aCreatedTask(String taskName, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task)});
        return task;
    }

    public Task aCreatedStandaloneTaskWithParent(String taskName) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, null);
        task.setParentTaskId(UUID.randomUUID().toString());
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task)});
        return task;
    }

    public Task aCreatedStandaloneAssignedTaskWithParent(String taskName, String username) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, null);
        task.setParentTaskId(UUID.randomUUID().toString());
        task.setAssignee(username);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task)});
        return task;
    }

    public Task anAssignedTask(String taskName, String username, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.ASSIGNED, processInstance);
        task.setAssignee(username);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task)});
        return task;
    }

    public QueryCloudTask anAssignedQueryCloudTask(String taskName, String username, ProcessInstance processInstance) {
        QueryCloudTaskImpl task = TaskEventContainedBuilder.buildQueryCloudTask(taskName, Task.TaskStatus.ASSIGNED, processInstance);
        task.setAssignee(username);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task)});
        return task;
    }

    public Task anAssignedTaskWithDueDate(String taskName, String username, ProcessInstance processInstance, Date dueDate) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.ASSIGNED, processInstance);
        task.setAssignee(username);
        task.setDueDate(dueDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task)});
        return task;
    }

    public Task anAssignedTaskWithParent(String taskName, String username, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.ASSIGNED, processInstance);
        task.setAssignee(username);
        task.setParentTaskId(UUID.randomUUID().toString());
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task)});
        return task;
    }

    public Task aCompletedTask(String taskName, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.COMPLETED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskCompletedEventImpl(UUID.randomUUID().toString(), Long.valueOf(new Date().getTime()), (Task)task)});
        return task;
    }

    public Task aCancelledTask(String taskName, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CANCELLED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskCancelledEventImpl(UUID.randomUUID().toString(), Long.valueOf(new Date().getTime()), (Task)task)});
        return task;
    }

    public Task aReleasedTask(String taskName) {
        TaskImpl task;
        TaskImpl releasedTask = task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.ASSIGNED, null);
        releasedTask.setStatus(Task.TaskStatus.CREATED);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskUpdatedEventImpl((Task)releasedTask)});
        return task;
    }

    public Task aCompletedTaskWithCreationDateAndCompletionDate(String taskName, ProcessInstance processInstance, Date createdDate, Date completedDate) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.COMPLETED, processInstance);
        task.setCreatedDate(createdDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl("task-created-event-id" + UUID.randomUUID().toString(), Long.valueOf(createdDate.getTime()), (Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskCompletedEventImpl("task-completed-event-id" + UUID.randomUUID().toString(), Long.valueOf(completedDate.getTime()), (Task)task)});
        return task;
    }

    public Task aTaskWithUserCandidate(String taskName, String username, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCandidateUserAddedEventImpl((TaskCandidateUser)new TaskCandidateUserImpl(username, task.getId()))});
        return task;
    }

    public QueryCloudTask aQueryCloudTaskWithUserCandidate(String taskName, String username, ProcessInstance processInstance) {
        QueryCloudTaskImpl task = TaskEventContainedBuilder.buildQueryCloudTask(taskName, Task.TaskStatus.CREATED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCandidateUserAddedEventImpl((TaskCandidateUser)new TaskCandidateUserImpl(username, task.getId()))});
        return task;
    }

    public Task aTaskWithGroupCandidate(String taskName, String groupId, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCandidateGroupAddedEventImpl((TaskCandidateGroup)new TaskCandidateGroupImpl(groupId, task.getId()))});
        return task;
    }

    public QueryCloudTask aQueryCloudTaskWithGroupCandidate(String taskName, String groupId, ProcessInstance processInstance) {
        QueryCloudTaskImpl task = TaskEventContainedBuilder.buildQueryCloudTask(taskName, Task.TaskStatus.CREATED, processInstance);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCandidateGroupAddedEventImpl((TaskCandidateGroup)new TaskCandidateGroupImpl(groupId, task.getId()))});
        return task;
    }

    public Task aTaskWithTwoGroupCandidates(String taskName, String groupIdOne, String groupIdTwo, ProcessInstance processInstance, String userName) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, processInstance);
        task.setAssignee(userName);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCandidateGroupAddedEventImpl((TaskCandidateGroup)new TaskCandidateGroupImpl(groupIdOne, task.getId())), new CloudTaskCandidateGroupAddedEventImpl((TaskCandidateGroup)new TaskCandidateGroupImpl(groupIdTwo, task.getId()))});
        return task;
    }

    public Task aTaskWithPriority(String taskName, int priority, ProcessInstance processInstance) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.CREATED, processInstance);
        task.setPriority(priority);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskCompletedEventImpl((Task)task)});
        return task;
    }

    public static TaskImpl buildTask(String taskName, Task.TaskStatus status, ProcessInstance processInstance) {
        TaskImpl task = new TaskImpl(UUID.randomUUID().toString(), taskName, status);
        task.setCreatedDate(new Date());
        if (processInstance != null) {
            task.setProcessInstanceId(processInstance.getId());
            task.setTaskProcessRootProcessInstanceId(processInstance.getRootProcessInstanceId());
        }
        return task;
    }

    public static QueryCloudTaskImpl buildQueryCloudTask(String taskName, Task.TaskStatus status, ProcessInstance processInstance) {
        QueryCloudTaskImpl task = new QueryCloudTaskImpl();
        task.setId(UUID.randomUUID().toString());
        task.setName(taskName);
        task.setStatus(status);
        task.setCreatedDate(new Date());
        if (processInstance != null) {
            task.setProcessInstanceId(processInstance.getId());
            task.setTaskProcessRootProcessInstanceId(processInstance.getRootProcessInstanceId());
        }
        return task;
    }

    public Task aCompletedTaskWithCompletedBy(String taskName, ProcessInstance processInstance, String completedBy) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.COMPLETED, processInstance);
        task.setCompletedBy(completedBy);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskCompletedEventImpl(UUID.randomUUID().toString(), Long.valueOf(new Date().getTime()), (Task)task)});
        return task;
    }

    public Task aCompletedTaskWithCompletionDate(String taskName, ProcessInstance processInstance, Date completedDate) {
        TaskImpl task = TaskEventContainedBuilder.buildTask(taskName, Task.TaskStatus.COMPLETED, processInstance);
        task.setCompletedDate(completedDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudTaskCreatedEventImpl((Task)task), new CloudTaskAssignedEventImpl((Task)task), new CloudTaskCompletedEventImpl("task-completed-event-id" + UUID.randomUUID().toString(), Long.valueOf(completedDate.getTime()), (Task)task)});
        return task;
    }
}

