/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.asserts;

import io.restassured.module.mockmvc.response.MockMvcResponse;
import org.activiti.cloud.services.common.file.FileContent;
import org.activiti.cloud.services.test.asserts.AssertFileContent;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;

public class AssertResponseContent {
    private static final String ATTACHMENT_CONTENT_DISPOSITION = "attachment;filename=";
    private final MockHttpServletResponse response;

    public AssertResponseContent(MockHttpServletResponse response) {
        this.response = response;
    }

    public AssertFileContent isFile() {
        Assertions.assertThat((Object)this.response).isNotNull();
        Assertions.assertThat((String)this.response.getContentType()).isNotNull();
        Assertions.assertThat((byte[])this.response.getContentAsByteArray()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)this.response.getHeader("Content-Disposition")).isNotEmpty()).startsWith((CharSequence)ATTACHMENT_CONTENT_DISPOSITION);
        String filename = this.response.getHeader("Content-Disposition").substring(ATTACHMENT_CONTENT_DISPOSITION.length());
        return new AssertFileContent(new FileContent(filename, this.response.getContentType(), this.response.getContentAsByteArray()));
    }

    public static AssertResponseContent assertThatResponseContent(MvcResult mvcResult) {
        return AssertResponseContent.assertThatResponseContent(mvcResult.getResponse());
    }

    public static AssertResponseContent assertThatResponseContent(MockMvcResponse response) {
        return AssertResponseContent.assertThatResponseContent(response.mockHttpServletResponse());
    }

    public static AssertResponseContent assertThatResponseContent(MockHttpServletResponse response) {
        return new AssertResponseContent(response);
    }
}

