/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.rest.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TestMvcClient {
    public static MediaType DEFAULT_MEDIA_TYPE = MediaTypes.HAL_JSON;
    private final MockMvc mvc;
    private final LinkDiscoverers discoverers;
    private String basePath = "/";

    public TestMvcClient(MockMvc mvc, LinkDiscoverers discoverers) {
        Assertions.assertThat((Object)mvc).isNotNull();
        Assertions.assertThat((Object)discoverers).isNotNull();
        this.mvc = mvc;
        this.discoverers = discoverers;
    }

    public TestMvcClient setBasePath(String uri) {
        this.basePath = uri;
        return this;
    }

    public static void initWebTest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes((HttpServletRequest)request);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
    }

    public static void assertAllowHeaders(HttpEntity<?> response, HttpMethod ... methods) {
        HttpHeaders headers = response.getHeaders();
        Assertions.assertThat((Collection)headers.getAllow()).containsExactly((Object[])methods);
    }

    public MockHttpServletResponse request(String href, MediaType contentType) throws Exception {
        return this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)href, (Object[])new Object[0]).accept(new MediaType[]{contentType})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentTypeCompatibleWith(contentType)).andReturn().getResponse();
    }

    public MockHttpServletResponse request(String href, MediaType contentType, HttpHeaders httpHeaders) throws Exception {
        return this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)href, (Object[])new Object[0]).accept(new MediaType[]{contentType}).headers(httpHeaders)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(contentType)).andReturn().getResponse();
    }

    public MockHttpServletResponse request(Link link) throws Exception {
        return this.request(link.expand(new Object[0]).getHref());
    }

    public MockHttpServletResponse request(Link link, MediaType mediaType) throws Exception {
        return this.request(link.expand(new Object[0]).getHref(), mediaType);
    }

    public MockHttpServletResponse request(String href) throws Exception {
        return this.request(href, DEFAULT_MEDIA_TYPE);
    }

    public ResultActions follow(Link link) throws Exception {
        return this.follow(link.expand(new Object[0]).getHref());
    }

    public ResultActions follow(String href) throws Exception {
        return this.follow(href, MediaType.ALL);
    }

    public ResultActions follow(Link link, MediaType accept) throws Exception {
        return this.follow(link.expand(new Object[0]).getHref(), accept);
    }

    public ResultActions follow(String href, MediaType accept) throws Exception {
        return this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)href, (Object[])new Object[0]).header("Accept", new Object[]{accept.toString()}));
    }

    public List<Link> discover(String rel) throws Exception {
        return this.discover(Link.of((String)this.basePath), rel);
    }

    public Link discoverUnique(String rel) throws Exception {
        List<Link> discover = this.discover(rel);
        Assertions.assertThat(discover).hasSize(1);
        return discover.get(0);
    }

    public Link discoverUnique(String ... rels) throws Exception {
        Iterator<String> toTraverse = Arrays.asList(rels).iterator();
        Link lastLink = null;
        while (toTraverse.hasNext()) {
            String rel = toTraverse.next();
            lastLink = lastLink == null ? this.discoverUnique(rel) : this.discoverUnique(lastLink, rel);
        }
        return lastLink;
    }

    public List<Link> discover(Link root, String rel) throws Exception {
        MockHttpServletResponse response = this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)root.expand(new Object[0]).getHref(), (Object[])new Object[0]).accept(new MediaType[]{DEFAULT_MEDIA_TYPE})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(this.hasLinkWithRel(rel)).andReturn().getResponse();
        String s = response.getContentAsString();
        return this.getDiscoverer(response).findLinksWithRel(rel, s).toList();
    }

    public Link discoverUnique(Link root, String rel) throws Exception {
        return this.discoverUnique(root, rel, DEFAULT_MEDIA_TYPE);
    }

    public Link discoverUnique(Link root, String rel, MediaType mediaType) throws Exception {
        MockHttpServletResponse response = this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)root.expand(new Object[0]).getHref(), (Object[])new Object[0]).accept(new MediaType[]{mediaType})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(this.hasLinkWithRel(rel)).andReturn().getResponse();
        return this.assertHasLinkWithRel(rel, response);
    }

    public Link assertHasLinkWithRel(String rel, MockHttpServletResponse response) throws Exception {
        String content = response.getContentAsString();
        Optional link = this.getDiscoverer(response).findLinkWithRel(rel, content);
        ((OptionalAssert)Assertions.assertThat((Optional)link).describedAs("Expected to find link with rel " + rel + " but found none in " + content + "!", new Object[0])).isPresent();
        return (Link)link.get();
    }

    public ResultMatcher hasLinkWithRel(final String rel) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                MockHttpServletResponse response = result.getResponse();
                String s = response.getContentAsString();
                ((OptionalAssert)Assertions.assertThat((Optional)TestMvcClient.this.getDiscoverer(response).findLinkWithRel(rel, s)).describedAs("Expected to find link with rel " + rel + " but found none in " + s, new Object[0])).isNotNull();
            }
        };
    }

    public LinkDiscoverer getDiscoverer(MockHttpServletResponse response) {
        String contentType = response.getContentType();
        Optional linkDiscovererFor = this.discoverers.getLinkDiscovererFor(contentType);
        ((OptionalAssert)Assertions.assertThat((Optional)linkDiscovererFor).describedAs("Did not find a LinkDiscoverer for returned media type " + contentType + "!", new Object[0])).isPresent();
        return (LinkDiscoverer)linkDiscovererFor.get();
    }
}

