/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starters.test.builder;

import java.util.Date;
import java.util.UUID;
import org.activiti.api.process.model.BPMNActivity;
import org.activiti.api.process.model.BPMNSequenceFlow;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.runtime.model.impl.BPMNActivityImpl;
import org.activiti.api.runtime.model.impl.BPMNSequenceFlowImpl;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.impl.QueryCloudProcessInstanceImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNActivityCompletedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNActivityStartedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCompletedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCreatedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessStartedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessSuspendedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudSequenceFlowTakenEventImpl;
import org.activiti.cloud.starters.test.EventsAggregator;

public class ProcessInstanceEventContainedBuilder {
    private final EventsAggregator eventsAggregator;

    public ProcessInstanceEventContainedBuilder(EventsAggregator eventsAggregator) {
        this.eventsAggregator = eventsAggregator;
    }

    public ProcessInstance aCompletedProcessInstance(String name) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance, null, null), new CloudProcessCompletedEventImpl((ProcessInstance)processInstance)});
        return processInstance;
    }

    public ProcessInstanceImpl aRunningProcessInstance(String name) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance, null, null)});
        return processInstance;
    }

    public ProcessInstanceImpl startSimpleProcessInstance(String processDefinitionId) {
        ProcessInstanceImpl process = new ProcessInstanceImpl();
        process.setId(UUID.randomUUID().toString());
        process.setName("process");
        process.setProcessDefinitionKey("mySimpleProcess");
        process.setProcessDefinitionId(processDefinitionId);
        process.setProcessDefinitionVersion(Integer.valueOf(1));
        BPMNActivityImpl startActivity = new BPMNActivityImpl("startEvent1", "", "startEvent");
        startActivity.setProcessDefinitionId(process.getProcessDefinitionId());
        startActivity.setProcessInstanceId(process.getId());
        startActivity.setExecutionId(UUID.randomUUID().toString());
        BPMNSequenceFlowImpl sequenceFlow = new BPMNSequenceFlowImpl("sid-68945AF1-396F-4B8A-B836-FC318F62313F", "startEvent1", "sid-CDFE7219-4627-43E9-8CA8-866CC38EBA94");
        sequenceFlow.setProcessDefinitionId(process.getProcessDefinitionId());
        sequenceFlow.setProcessInstanceId(process.getId());
        BPMNActivityImpl taskActivity = new BPMNActivityImpl("sid-CDFE7219-4627-43E9-8CA8-866CC38EBA94", "Perform Action", "userTask");
        taskActivity.setProcessDefinitionId(process.getProcessDefinitionId());
        taskActivity.setProcessInstanceId(process.getId());
        taskActivity.setExecutionId(UUID.randomUUID().toString());
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)process), new CloudProcessStartedEventImpl((ProcessInstance)process, null, null), new CloudBPMNActivityStartedEventImpl((BPMNActivity)startActivity, processDefinitionId, process.getId()), new CloudBPMNActivityCompletedEventImpl((BPMNActivity)startActivity, processDefinitionId, process.getId()), new CloudSequenceFlowTakenEventImpl((BPMNSequenceFlow)sequenceFlow), new CloudBPMNActivityStartedEventImpl((BPMNActivity)taskActivity, processDefinitionId, process.getId())});
        return process;
    }

    private ProcessInstanceImpl buildProcessInstance(String name) {
        return this.buildProcessInstance(name, "testuser");
    }

    private ProcessInstanceImpl buildProcessInstance(String name, String initiator) {
        ProcessInstanceImpl completedProcess = new ProcessInstanceImpl();
        completedProcess.setId(UUID.randomUUID().toString());
        completedProcess.setInitiator(initiator);
        completedProcess.setName(name);
        completedProcess.setProcessDefinitionKey("my-proc");
        completedProcess.setProcessDefinitionId(UUID.randomUUID().toString());
        completedProcess.setProcessDefinitionName("my-proc-definition-name");
        completedProcess.setRootProcessInstanceId("rootProcessInstanceId");
        return completedProcess;
    }

    private QueryCloudProcessInstanceImpl buildSuspendedProcessInstance(String name) {
        QueryCloudProcessInstanceImpl suspendedProcess = new QueryCloudProcessInstanceImpl();
        suspendedProcess.setId(UUID.randomUUID().toString());
        suspendedProcess.setInitiator("testuser");
        suspendedProcess.setName(name);
        suspendedProcess.setProcessDefinitionKey("my-proc");
        suspendedProcess.setProcessDefinitionId(UUID.randomUUID().toString());
        suspendedProcess.setProcessDefinitionName("my-proc-definition-name");
        suspendedProcess.setStatus(ProcessInstance.ProcessInstanceStatus.SUSPENDED);
        return suspendedProcess;
    }

    public ProcessInstanceImpl aRunningProcessInstanceWithStartDate(String name, Date startDate) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name);
        processInstance.setStartDate(startDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance)});
        return processInstance;
    }

    public ProcessInstanceImpl aRunningProcessInstanceWithCompletedDate(String name, Date completedDate) {
        ProcessInstanceImpl completedProcess = this.buildProcessInstance(name);
        completedProcess.setCompletedDate(completedDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)completedProcess), new CloudProcessCompletedEventImpl(UUID.randomUUID().toString(), Long.valueOf(completedDate.getTime()), (ProcessInstance)completedProcess)});
        return completedProcess;
    }

    public ProcessInstanceImpl aRunningProcessInstanceWithInitiator(String name, String initiator) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name, initiator);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance)});
        return processInstance;
    }

    public ProcessInstanceImpl aRunningProcessInstanceWithAppVersion(String name, String appVersion) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name);
        processInstance.setAppVersion(appVersion);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance)});
        return processInstance;
    }

    public ProcessInstanceImpl aCompletedProcessInstanceWithAppVersion(String name, String appVersion) {
        ProcessInstanceImpl processInstance = this.buildProcessInstance(name);
        processInstance.setAppVersion(appVersion);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)processInstance), new CloudProcessStartedEventImpl((ProcessInstance)processInstance), new CloudProcessCompletedEventImpl((ProcessInstance)processInstance)});
        return processInstance;
    }

    public QueryCloudProcessInstanceImpl aRunningProcessInstanceWithSuspendedDate(String name, Date suspendedDate) {
        QueryCloudProcessInstanceImpl suspendedProcess = this.buildSuspendedProcessInstance(name);
        suspendedProcess.setSuspendedDate(suspendedDate);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudProcessCreatedEventImpl((ProcessInstance)suspendedProcess), new CloudProcessSuspendedEventImpl(UUID.randomUUID().toString(), Long.valueOf(suspendedDate.getTime()), (ProcessInstance)suspendedProcess)});
        return suspendedProcess;
    }
}

