/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.identity.keycloak;

import java.util.Map;
import org.activiti.cloud.services.test.identity.IdentityTokenProducer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class KeycloakTokenProducer
implements IdentityTokenProducer {
    public static final String TOKEN_ENDPOINT = "%s/realms/%s/protocol/openid-connect/token";
    public static final String TOKEN_FIELD = "access_token";
    @Value(value="${keycloak.resource:}")
    protected String resource;
    @Value(value="${keycloak.auth-server-url:}")
    private String authServerUrl;
    @Value(value="${keycloak.realm:}")
    private String realm;
    @Value(value="${activiti.identity.test-user:}")
    protected String testUser;
    @Value(value="${activiti.identity.test-password:}")
    protected String testPassword;

    public KeycloakTokenProducer(String authServerUrl, String realm) {
        this.authServerUrl = authServerUrl;
        this.realm = realm;
    }

    @Override
    public String getTokenString() {
        return "Bearer " + this.getAccessTokenString();
    }

    @Override
    public String getAccessTokenString() {
        String token = this.getAccessTokenResponse(this.testUser, this.testPassword);
        return token;
    }

    @Override
    public IdentityTokenProducer withTestUser(String keycloakTestUser) {
        this.testUser = keycloakTestUser;
        return this;
    }

    @Override
    public IdentityTokenProducer withTestPassword(String testPassword) {
        this.testPassword = testPassword;
        return this;
    }

    @Override
    public IdentityTokenProducer withResource(String resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public HttpEntity entityWithAuthorizationHeader(String user, String password) {
        HttpHeaders headers = this.authorizationHeaders(user, password);
        return new HttpEntity((MultiValueMap)headers);
    }

    @Override
    public HttpEntity entityWithoutAuthentication() {
        HttpHeaders headers = new HttpHeaders();
        return new HttpEntity((MultiValueMap)headers);
    }

    @Override
    public HttpEntity entityWithAuthorizationHeader() {
        HttpHeaders headers = this.authorizationHeaders();
        return new HttpEntity((MultiValueMap)headers);
    }

    @Override
    public String getTestUser() {
        return this.testUser;
    }

    @Override
    public HttpHeaders authorizationHeaders() {
        return this.authorizationHeaders(this.testUser, this.testPassword);
    }

    private String getTokenString(String user, String password) {
        String token = this.getAccessTokenResponse(user, password);
        return "Bearer " + token;
    }

    private HttpHeaders authorizationHeaders(String user, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getTokenString(user, password));
        return headers;
    }

    private String getAccessTokenResponse(String user, String password) {
        String url = String.format(TOKEN_ENDPOINT, this.authServerUrl, this.realm);
        ResponseEntity<Map> response = this.callTokenEndpoint(url, user, password);
        return (String)((Map)response.getBody()).get(TOKEN_FIELD);
    }

    private ResponseEntity<Map> callTokenEndpoint(String url, String user, String password) {
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap requestParams = new LinkedMultiValueMap();
        requestParams.add((Object)"client_id", (Object)this.resource);
        requestParams.add((Object)"username", (Object)user);
        requestParams.add((Object)"password", (Object)password);
        requestParams.add((Object)"grant_type", (Object)"password");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestParams, (MultiValueMap)headers);
        return restTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
    }
}

