/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.identity.listener;

import org.activiti.cloud.services.test.identity.keycloak.KeycloakTokenProducer;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class KeycloakTokenProducerCleanListener
implements TestExecutionListener,
Ordered {
    private Logger logger = LoggerFactory.getLogger(KeycloakTokenProducerCleanListener.class);
    private static final String RESOURCE = "keycloak.resource";
    private static final String TEST_USER = "activiti.identity.test-user";
    private static final String TEST_PASSWORD = "activiti.identity.test-password";

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        try {
            KeycloakTokenProducer tokenProducer = (KeycloakTokenProducer)testContext.getApplicationContext().getBean(KeycloakTokenProducer.class);
            Environment env = testContext.getApplicationContext().getEnvironment();
            tokenProducer.withTestUser(env.getProperty(TEST_USER, "")).withTestPassword(env.getProperty(TEST_PASSWORD, "")).withResource(env.getProperty(RESOURCE, ""));
        }
        catch (BeansException e) {
            this.logger.debug(() -> "No bean of type IdentityTokenProducer: skipping.");
        }
    }
}

