/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.assemblers;

import org.activiti.api.process.model.ProcessInstance;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.activiti.cloud.services.rest.assemblers.ToCloudProcessInstanceConverter;
import org.activiti.cloud.services.rest.controllers.HomeControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceVariableControllerImpl;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class ProcessInstanceRepresentationModelAssembler
implements RepresentationModelAssembler<ProcessInstance, EntityModel<CloudProcessInstance>> {
    private ToCloudProcessInstanceConverter toCloudProcessInstanceConverter;

    public ProcessInstanceRepresentationModelAssembler(ToCloudProcessInstanceConverter toCloudProcessInstanceConverter) {
        this.toCloudProcessInstanceConverter = toCloudProcessInstanceConverter;
    }

    public EntityModel<CloudProcessInstance> toModel(ProcessInstance processInstance) {
        CloudProcessInstance cloudProcessInstance = this.toCloudProcessInstanceConverter.from(processInstance);
        Link processInstancesRel = WebMvcLinkBuilder.linkTo(((ProcessInstanceControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceControllerImpl.class, (Object[])new Object[0])).getProcessInstances(null)).withRel("processInstances");
        Link selfLink = WebMvcLinkBuilder.linkTo(((ProcessInstanceControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceControllerImpl.class, (Object[])new Object[0])).getProcessInstanceById(cloudProcessInstance.getId())).withSelfRel();
        Link variablesLink = WebMvcLinkBuilder.linkTo(((ProcessInstanceVariableControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceVariableControllerImpl.class, (Object[])new Object[0])).getVariables(cloudProcessInstance.getId())).withRel("variables");
        Link homeLink = WebMvcLinkBuilder.linkTo(HomeControllerImpl.class).withRel("home");
        return EntityModel.of((Object)cloudProcessInstance, (Link[])new Link[]{selfLink, variablesLink, processInstancesRel, homeLink});
    }
}

