/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.runtime.ProcessRuntime;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.rest.api.ProcessInstanceVariableController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ProcessInstanceVariableRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceVariableControllerImpl
implements ProcessInstanceVariableController {
    private final ProcessInstanceVariableRepresentationModelAssembler variableRepresentationModelAssembler;
    private final ProcessRuntime processRuntime;
    private final CollectionModelAssembler resourcesAssembler;

    @Autowired
    public ProcessInstanceVariableControllerImpl(ProcessInstanceVariableRepresentationModelAssembler variableRepresentationModelAssembler, ProcessRuntime processRuntime, CollectionModelAssembler resourcesAssembler) {
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.processRuntime = processRuntime;
        this.resourcesAssembler = resourcesAssembler;
    }

    public CollectionModel<EntityModel<CloudVariableInstance>> getVariables(@PathVariable String processInstanceId) {
        return this.resourcesAssembler.toCollectionModel(this.processRuntime.variables(ProcessPayloadBuilder.variables().withProcessInstanceId(processInstanceId).build()), this.variableRepresentationModelAssembler, new Link[0]);
    }

    public ResponseEntity<Void> updateVariables(@PathVariable String processInstanceId, @RequestBody SetProcessVariablesPayload setProcessVariablesPayload) {
        if (setProcessVariablesPayload != null) {
            setProcessVariablesPayload.setProcessInstanceId(processInstanceId);
        }
        this.processRuntime.setVariables(setProcessVariablesPayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

