/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.assemblers;

import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.cloud.api.process.model.CloudProcessDefinition;
import org.activiti.cloud.api.process.model.ExtendedCloudProcessDefinition;
import org.activiti.cloud.services.rest.assemblers.ToCloudProcessDefinitionConverter;
import org.activiti.cloud.services.rest.controllers.HomeControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessDefinitionControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceControllerImpl;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class ProcessDefinitionRepresentationModelAssembler
implements RepresentationModelAssembler<ProcessDefinition, EntityModel<CloudProcessDefinition>> {
    private ToCloudProcessDefinitionConverter converter;

    public ProcessDefinitionRepresentationModelAssembler(ToCloudProcessDefinitionConverter converter) {
        this.converter = converter;
    }

    public EntityModel<CloudProcessDefinition> toModel(ProcessDefinition processDefinition) {
        ExtendedCloudProcessDefinition cloudProcessDefinition = this.converter.from(processDefinition);
        Link selfRel = WebMvcLinkBuilder.linkTo(((ProcessDefinitionControllerImpl)WebMvcLinkBuilder.methodOn(ProcessDefinitionControllerImpl.class, (Object[])new Object[0])).getProcessDefinition(cloudProcessDefinition.getId())).withSelfRel();
        Link startProcessLink = WebMvcLinkBuilder.linkTo(((ProcessInstanceControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceControllerImpl.class, (Object[])new Object[0])).startProcess(null)).withRel("startProcess");
        Link homeLink = WebMvcLinkBuilder.linkTo(HomeControllerImpl.class).withRel("home");
        return EntityModel.of((Object)cloudProcessDefinition, (Link[])new Link[]{selfRel, startProcessLink, homeLink});
    }
}

