/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import jakarta.servlet.http.HttpServletResponse;
import org.activiti.api.model.shared.model.ActivitiErrorMessage;
import org.activiti.api.runtime.model.impl.ActivitiErrorMessageImpl;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.UnprocessableEntityException;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.image.exception.ActivitiInterchangeInfoNotFoundException;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RuntimeBundleExceptionHandler {
    @ExceptionHandler(value={ActivitiInterchangeInfoNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public EntityModel<ActivitiErrorMessage> handleAppException(ActivitiInterchangeInfoNotFoundException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.NOT_FOUND.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={ActivitiForbiddenException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public EntityModel<ActivitiErrorMessage> handleAppException(ActivitiForbiddenException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.FORBIDDEN.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={UnprocessableEntityException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public EntityModel<ActivitiErrorMessage> handleAppException(UnprocessableEntityException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.UNPROCESSABLE_ENTITY.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={NotFoundException.class, ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public EntityModel<ActivitiErrorMessage> handleAppException(RuntimeException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.NOT_FOUND.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public EntityModel<ActivitiErrorMessage> handleAppException(IllegalStateException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.BAD_REQUEST.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public EntityModel<ActivitiErrorMessage> handleAppException(ActivitiException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.BAD_REQUEST.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public EntityModel<ActivitiErrorMessage> handleAppException(ActivitiIllegalArgumentException ex, HttpServletResponse response) {
        response.setContentType("application/json");
        return EntityModel.of((Object)new ActivitiErrorMessageImpl(HttpStatus.CONFLICT.value(), ex.getMessage()));
    }
}

