/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.cloud.api.process.model.impl.CandidateUser;
import org.activiti.cloud.services.rest.api.CandidateUserAdminController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ToCandidateUserConverter;
import org.activiti.cloud.services.rest.assemblers.UserCandidatesRepresentationModelAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CandidateUserAdminControllerImpl
implements CandidateUserAdminController {
    private final TaskAdminRuntime taskAdminRuntime;
    private final UserCandidatesRepresentationModelAssembler userCandidatesRepresentationModelAssembler;
    private final ToCandidateUserConverter toCandidateUserConverter;
    private final CollectionModelAssembler resourcesAssembler;

    public CandidateUserAdminControllerImpl(TaskAdminRuntime taskAdminRuntime, UserCandidatesRepresentationModelAssembler userCandidatesRepresentationModelAssembler, ToCandidateUserConverter toCandidateUserConverter, CollectionModelAssembler resourcesAssembler) {
        this.taskAdminRuntime = taskAdminRuntime;
        this.userCandidatesRepresentationModelAssembler = userCandidatesRepresentationModelAssembler;
        this.toCandidateUserConverter = toCandidateUserConverter;
        this.resourcesAssembler = resourcesAssembler;
    }

    public void addCandidateUsers(@PathVariable String taskId, @RequestBody CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload != null) {
            candidateUsersPayload.setTaskId(taskId);
        }
        this.taskAdminRuntime.addCandidateUsers(candidateUsersPayload);
    }

    public void deleteCandidateUsers(@PathVariable String taskId, @RequestBody CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload != null) {
            candidateUsersPayload.setTaskId(taskId);
        }
        this.taskAdminRuntime.deleteCandidateUsers(candidateUsersPayload);
    }

    public CollectionModel<EntityModel<CandidateUser>> getUserCandidates(@PathVariable String taskId) {
        this.userCandidatesRepresentationModelAssembler.setTaskId(taskId);
        return this.resourcesAssembler.toCollectionModel(this.toCandidateUserConverter.from(this.taskAdminRuntime.userCandidates(taskId)), this.userCandidatesRepresentationModelAssembler, WebMvcLinkBuilder.linkTo(((CandidateUserAdminControllerImpl)WebMvcLinkBuilder.methodOn(this.getClass(), (Object[])new Object[0])).getUserCandidates(this.userCandidatesRepresentationModelAssembler.getTaskId())).withSelfRel());
    }
}

