/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.assemblers;

import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.rest.assemblers.ToCloudVariableInstanceConverter;
import org.activiti.cloud.services.rest.controllers.HomeControllerImpl;
import org.activiti.cloud.services.rest.controllers.TaskControllerImpl;
import org.activiti.cloud.services.rest.controllers.TaskVariableControllerImpl;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class TaskVariableInstanceRepresentationModelAssembler
implements RepresentationModelAssembler<VariableInstance, EntityModel<CloudVariableInstance>> {
    private ToCloudVariableInstanceConverter converter;

    public TaskVariableInstanceRepresentationModelAssembler(ToCloudVariableInstanceConverter converter) {
        this.converter = converter;
    }

    public EntityModel<CloudVariableInstance> toModel(VariableInstance taskVariable) {
        CloudVariableInstance cloudVariableInstance = this.converter.from(taskVariable);
        Link globalVariables = WebMvcLinkBuilder.linkTo(((TaskVariableControllerImpl)WebMvcLinkBuilder.methodOn(TaskVariableControllerImpl.class, (Object[])new Object[0])).getVariables(cloudVariableInstance.getTaskId())).withRel("variables");
        Link taskRel = WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).getTaskById(cloudVariableInstance.getTaskId())).withRel("task");
        Link homeLink = WebMvcLinkBuilder.linkTo(HomeControllerImpl.class).withRel("home");
        return EntityModel.of((Object)cloudVariableInstance, (Link[])new Link[]{globalVariables, taskRel, homeLink});
    }
}

