/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.AssignTasksPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.CloudTask;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.rest.api.TaskAdminController;
import org.activiti.cloud.services.rest.assemblers.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskAdminControllerImpl
implements TaskAdminController {
    private final TaskAdminRuntime taskAdminRuntime;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler;
    private final SpringPageConverter pageConverter;

    @Autowired
    public TaskAdminControllerImpl(TaskAdminRuntime taskAdminRuntime, TaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler, SpringPageConverter pageConverter) {
        this.taskAdminRuntime = taskAdminRuntime;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.pageConverter = pageConverter;
    }

    public PagedModel<EntityModel<CloudTask>> getTasks(Pageable pageable) {
        Page tasksPage = this.taskAdminRuntime.tasks(this.pageConverter.toAPIPageable(pageable));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, tasksPage), (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    public EntityModel<CloudTask> getTaskById(@PathVariable String taskId) {
        Task task = this.taskAdminRuntime.task(taskId);
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> completeTask(@PathVariable String taskId, @RequestBody(required=false) CompleteTaskPayload completeTaskPayload) {
        if (completeTaskPayload == null) {
            completeTaskPayload = TaskPayloadBuilder.complete().withTaskId(taskId).build();
        } else {
            completeTaskPayload.setTaskId(taskId);
        }
        Task task = this.taskAdminRuntime.complete(completeTaskPayload);
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> deleteTask(@PathVariable String taskId) {
        Task task = this.taskAdminRuntime.delete(TaskPayloadBuilder.delete().withTaskId(taskId).build());
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> updateTask(@PathVariable String taskId, @RequestBody UpdateTaskPayload updateTaskPayload) {
        if (updateTaskPayload != null) {
            updateTaskPayload.setTaskId(taskId);
        }
        return this.taskRepresentationModelAssembler.toModel(this.taskAdminRuntime.update(updateTaskPayload));
    }

    public EntityModel<CloudTask> assign(@PathVariable String taskId, @RequestBody AssignTaskPayload assignTaskPayload) {
        if (assignTaskPayload != null) {
            assignTaskPayload.setTaskId(taskId);
        }
        return this.taskRepresentationModelAssembler.toModel(this.taskAdminRuntime.assign(assignTaskPayload));
    }

    public PagedModel<EntityModel<CloudTask>> assign(@RequestBody AssignTasksPayload assignTasksPayload) {
        Page tasks = this.taskAdminRuntime.assignMultiple(assignTasksPayload);
        Pageable pageable = tasks.getTotalItems() == 0 ? Pageable.unpaged() : Pageable.ofSize((int)tasks.getTotalItems());
        return this.pagedCollectionModelAssembler.toModel(this.pageConverter.toSpringPage(pageable, tasks), (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }
}

