/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.UserTask;
import org.activiti.cloud.services.api.model.ProcessDefinitionMeta;
import org.activiti.cloud.services.api.model.ProcessDefinitionServiceTask;
import org.activiti.cloud.services.api.model.ProcessDefinitionUserTask;
import org.activiti.cloud.services.api.model.ProcessDefinitionVariable;
import org.activiti.cloud.services.rest.api.ProcessDefinitionMetaController;
import org.activiti.cloud.services.rest.assemblers.ProcessDefinitionMetaRepresentationModelAssembler;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionMetaControllerImpl
implements ProcessDefinitionMetaController {
    private final RepositoryService repositoryService;
    private final ProcessDefinitionMetaRepresentationModelAssembler representationModelAssembler;

    @Autowired
    public ProcessDefinitionMetaControllerImpl(RepositoryService repositoryService, ProcessDefinitionMetaRepresentationModelAssembler representationModelAssembler) {
        this.repositoryService = repositoryService;
        this.representationModelAssembler = representationModelAssembler;
    }

    public EntityModel<ProcessDefinitionMeta> getProcessDefinitionMetadata(@PathVariable String id) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Unable to find process definition for the given id:'" + id + "'");
        }
        List processes = this.repositoryService.getBpmnModel(id).getProcesses();
        HashSet<ProcessDefinitionVariable> variables = new HashSet<ProcessDefinitionVariable>();
        HashSet users = new HashSet();
        HashSet groups = new HashSet();
        HashSet<ProcessDefinitionUserTask> userTasks = new HashSet<ProcessDefinitionUserTask>();
        HashSet<ProcessDefinitionUserTask> serviceTasks = new HashSet<ProcessDefinitionUserTask>();
        for (Process process : processes) {
            variables.addAll(this.getVariables(process));
            List flowElementList = (List)process.getFlowElements();
            for (FlowElement flowElement : flowElementList) {
                ProcessDefinitionUserTask task;
                if (flowElement.getClass().equals(UserTask.class)) {
                    UserTask userTask = (UserTask)flowElement;
                    task = new ProcessDefinitionUserTask(userTask.getName(), userTask.getDocumentation());
                    userTasks.add(task);
                    users.addAll(userTask.getCandidateUsers());
                    groups.addAll(userTask.getCandidateGroups());
                }
                if (!flowElement.getClass().equals(ServiceTask.class)) continue;
                ServiceTask serviceTask = (ServiceTask)flowElement;
                task = new ProcessDefinitionServiceTask(serviceTask.getName(), serviceTask.getImplementation());
                serviceTasks.add(task);
            }
        }
        return this.representationModelAssembler.toModel(new ProcessDefinitionMeta(processDefinition.getId(), processDefinition.getName(), processDefinition.getDescription(), processDefinition.getVersion(), users, groups, variables, userTasks, serviceTasks));
    }

    private List<ProcessDefinitionVariable> getVariables(Process process) {
        ArrayList<ProcessDefinitionVariable> variables = new ArrayList<ProcessDefinitionVariable>();
        if (!process.getExtensionElements().isEmpty()) {
            for (List extensionElementList : process.getExtensionElements().values()) {
                for (ExtensionElement ee : extensionElementList) {
                    String name = ee.getAttributeValue(ee.getNamespace(), "variableName");
                    String type = ee.getAttributeValue(ee.getNamespace(), "variableType");
                    ProcessDefinitionVariable variable = new ProcessDefinitionVariable(name, type);
                    variables.add(variable);
                }
            }
        }
        return variables;
    }
}

