/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/admin/v1/process-instances"}, produces={"application/hal+json", "application/json"})
public interface ProcessInstanceAdminController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudProcessInstance>> getProcessInstances(Pageable var1);

    @RequestMapping(method={RequestMethod.POST})
    public EntityModel<CloudProcessInstance> startProcess(@RequestBody StartProcessPayload var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public EntityModel<CloudProcessInstance> getProcessInstanceById(@Parameter(description="Enter the processInstanceId to get process instance by id candidate groups") @PathVariable String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"{processInstanceId}/suspend"})
    public EntityModel<CloudProcessInstance> suspend(@Parameter(description="Enter the processInstanceId to suspend") @PathVariable String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"{processInstanceId}/resume"})
    public EntityModel<CloudProcessInstance> resume(@Parameter(description="Enter the processInstanceId to resume") @PathVariable String var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.DELETE})
    public EntityModel<CloudProcessInstance> deleteProcessInstance(@Parameter(description="Enter the processInstanceId to delete") @PathVariable String var1);

    @RequestMapping(value={"/{processInstanceId}/destroy"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> destroyProcessInstance(@Parameter(description="Enter the processInstanceId to destroy a process instance") @PathVariable String var1, @Parameter(description="Enable force delete if the process is still running") @RequestParam(value="force", required=false, defaultValue="false") boolean var2);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.PUT})
    public EntityModel<CloudProcessInstance> updateProcess(@Parameter(description="Enter the processInstanceId to update process") @PathVariable(value="processInstanceId") String var1, @RequestBody UpdateProcessPayload var2);

    @RequestMapping(value={"/{processInstanceId}/subprocesses"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudProcessInstance>> subprocesses(@PathVariable(value="processInstanceId") String var1, Pageable var2);

    @RequestMapping(value={"/message"}, method={RequestMethod.POST})
    public EntityModel<CloudProcessInstance> start(@RequestBody StartMessagePayload var1);

    @RequestMapping(value={"/message"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> receive(@RequestBody ReceiveMessagePayload var1);
}

