/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QTaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.QTaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.rest.ProcessInstanceSearchService;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.activiti.cloud.services.query.rest.specification.ProcessInstanceSpecification;
import org.activiti.cloud.services.security.ProcessInstanceRestrictionService;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class ProcessInstanceService {
    private static final String UNABLE_TO_FIND_PROCESS_FOR_THE_GIVEN_ID = "Unable to find process for the given id:'";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceService.class);
    private static final String ADMIN_ROLE = "ACTIVITI_ADMIN";
    private final ProcessInstanceRepository processInstanceRepository;
    private final TaskRepository taskRepository;
    private final ProcessInstanceSearchService processInstanceSearchService;
    private final ProcessInstanceRestrictionService processInstanceRestrictionService;
    private final SecurityPoliciesManager securityPoliciesApplicationService;
    private final SecurityManager securityManager;
    private final EntityFinder entityFinder;
    @PersistenceContext
    private EntityManager entityManager;

    public ProcessInstanceService(ProcessInstanceRepository processInstanceRepository, TaskRepository taskRepository, ProcessInstanceSearchService processInstanceSearchService, ProcessInstanceRestrictionService processInstanceRestrictionService, SecurityPoliciesManager securityPoliciesApplicationService, SecurityManager securityManager, EntityFinder entityFinder) {
        this.processInstanceRepository = processInstanceRepository;
        this.taskRepository = taskRepository;
        this.processInstanceSearchService = processInstanceSearchService;
        this.processInstanceRestrictionService = processInstanceRestrictionService;
        this.securityPoliciesApplicationService = securityPoliciesApplicationService;
        this.securityManager = securityManager;
        this.entityFinder = entityFinder;
    }

    public Page<ProcessInstanceEntity> findAll(Predicate predicate, Pageable pageable) {
        Predicate transformedPredicate = this.processInstanceRestrictionService.restrictProcessInstanceQuery(Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new), SecurityPolicyAccess.READ);
        return this.processInstanceRepository.findAll(transformedPredicate, pageable);
    }

    @Transactional
    public Page<ProcessInstanceEntity> findAllWithVariables(Predicate predicate, List<String> variableKeys, Pageable pageable) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        Filter filter = session.enableFilter("variablesFilter");
        filter.setParameterList("variableKeys", variableKeys);
        Page<ProcessInstanceEntity> processInstanceEntities = this.findAll(predicate, pageable);
        List ids = processInstanceEntities.map(ProcessInstanceEntity::getId).toList();
        List result = this.processInstanceRepository.findByIdIsIn((Collection)ids, pageable.getSort());
        return new PageImpl(result, pageable, processInstanceEntities.getTotalElements());
    }

    public ProcessInstanceEntity findById(String processInstanceId) {
        ProcessInstanceEntity processInstanceEntity = (ProcessInstanceEntity)this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)processInstanceId, String.format("Unable to find process instance for the given id:'%s'", processInstanceId));
        if (!this.canRead(processInstanceEntity)) {
            LOGGER.debug(String.format("User %s not permitted to access definition %s and/or process instance id %s", this.securityManager.getAuthenticatedUserId(), processInstanceEntity.getProcessDefinitionKey(), processInstanceId));
            throw new ActivitiForbiddenException(String.format("Operation not permitted for %s and/or process instance", processInstanceEntity.getProcessDefinitionKey()));
        }
        return processInstanceEntity;
    }

    public Page<ProcessInstanceEntity> subprocesses(String processInstanceId, Predicate predicate, Pageable pageable) {
        Predicate transformedPredicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        ProcessInstanceEntity processInstanceEntity = (ProcessInstanceEntity)this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)processInstanceId, UNABLE_TO_FIND_PROCESS_FOR_THE_GIVEN_ID + processInstanceId + "'");
        if (!this.canReadOrAdmin(processInstanceEntity)) {
            LOGGER.debug("User " + this.securityManager.getAuthenticatedUserId() + " not permitted to access definition " + processInstanceEntity.getProcessDefinitionKey() + " and/or process instance id " + processInstanceId);
            throw new ActivitiForbiddenException("Operation not permitted for " + processInstanceEntity.getProcessDefinitionKey() + " and/or process instance");
        }
        QProcessInstanceEntity process = QProcessInstanceEntity.processInstanceEntity;
        BooleanExpression expression = process.parentId.eq((Object)processInstanceId);
        BooleanExpression extendedPredicate = expression.and(transformedPredicate);
        return this.processInstanceRepository.findAll((Predicate)extendedPredicate, pageable);
    }

    @Transactional(readOnly=true)
    public Page<ProcessInstanceEntity> search(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        return this.processInstanceSearchService.searchRestricted(searchRequest, pageable);
    }

    public boolean canReadOrAdmin(ProcessInstanceEntity processInstanceEntity) {
        return this.canRead(processInstanceEntity) || this.securityManager.getAuthenticatedUserRoles().contains(ADMIN_ROLE);
    }

    private boolean canRead(ProcessInstanceEntity processInstanceEntity) {
        return this.securityPoliciesApplicationService.canRead(processInstanceEntity.getProcessDefinitionKey(), processInstanceEntity.getServiceName()) && (this.securityManager.getAuthenticatedUserId().equals(processInstanceEntity.getInitiator()) || this.isInvolvedInATask(processInstanceEntity.getId()));
    }

    private boolean isInvolvedInATask(String processInstanceId) {
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        List authenticatedUserGroups = this.securityManager.getAuthenticatedUserGroups();
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        BooleanExpression taskInvolved = taskEntity.assignee.eq((Object)authenticatedUserId).or((Predicate)taskEntity.owner.eq((Object)authenticatedUserId)).or((Predicate)((QTaskCandidateUserEntity)taskEntity.taskCandidateUsers.any()).userId.eq((Object)authenticatedUserId));
        if (authenticatedUserGroups != null && authenticatedUserGroups.size() > 0) {
            taskInvolved = taskInvolved.or((Predicate)((QTaskCandidateGroupEntity)taskEntity.taskCandidateGroups.any()).groupId.in((Collection)authenticatedUserGroups));
        }
        BooleanExpression whereExpression = taskEntity.processInstanceId.eq((Object)processInstanceId).and((Predicate)taskInvolved);
        return this.taskRepository.exists((Predicate)whereExpression);
    }

    @Transactional(readOnly=true)
    public Long count(ProcessInstanceSearchRequest searchRequest) {
        return this.processInstanceSearchService.countRestricted(searchRequest);
    }

    @Transactional(readOnly=true)
    public Page<ProcessInstanceEntity> searchLinkedProcesses(String linkedProcessInstanceId, Pageable pageable) {
        this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)linkedProcessInstanceId, UNABLE_TO_FIND_PROCESS_FOR_THE_GIVEN_ID + linkedProcessInstanceId + "'");
        String userId = this.securityManager.getAuthenticatedUserId();
        ProcessInstanceSpecification restrictedSpecification = ProcessInstanceSpecification.restrictedLinkedProcesses(linkedProcessInstanceId, userId);
        return this.processInstanceRepository.findAll((Specification)restrictedSpecification, pageable);
    }

    @Transactional(readOnly=true)
    public List<ProcessInstanceEntity> searchLinkedProcesses(String linkedProcessInstanceId) {
        this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)linkedProcessInstanceId, UNABLE_TO_FIND_PROCESS_FOR_THE_GIVEN_ID + linkedProcessInstanceId + "'");
        String userId = this.securityManager.getAuthenticatedUserId();
        ProcessInstanceSpecification restrictedSpecification = ProcessInstanceSpecification.restrictedLinkedProcesses(linkedProcessInstanceId, userId);
        return this.processInstanceRepository.findAll((Specification)restrictedSpecification);
    }

    public void linkProcessInstances(String mainProcessInstanceId, List<String> processInstanceIds, String linkProcessInstanceType) {
        ProcessInstanceEntity mainProcess = (ProcessInstanceEntity)this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)mainProcessInstanceId, UNABLE_TO_FIND_PROCESS_FOR_THE_GIVEN_ID + mainProcessInstanceId + "'");
        if (processInstanceIds != null && !processInstanceIds.isEmpty()) {
            ProcessInstanceSearchRequest request = new ProcessInstanceSearchRequest();
            request.setId(new HashSet<String>(processInstanceIds));
            request.setLinkedProcessInstanceType(Set.of(linkProcessInstanceType));
            List orphanProcesses = this.processInstanceRepository.findAll((Specification)ProcessInstanceSpecification.restricted(request, this.securityManager.getAuthenticatedUserId()));
            if (orphanProcesses.isEmpty()) {
                LOGGER.debug("No process instance found for the given ids:'{}'", processInstanceIds);
                return;
            }
            orphanProcesses.forEach(orphanProcess -> {
                if (orphanProcess.getInitiator().equals(mainProcess.getInitiator())) {
                    orphanProcess.setLinkedProcessInstanceId(mainProcess.getId());
                    this.processInstanceRepository.save(orphanProcess);
                } else {
                    LOGGER.debug("User {} not permitted to link process instance id {} to main process instance id {}", new Object[]{this.securityManager.getAuthenticatedUserId(), orphanProcess.getId(), mainProcessInstanceId});
                }
            });
        } else {
            LOGGER.debug("No process instance id provided to link to main process instance id '{}'", (Object)mainProcessInstanceId);
        }
    }
}

