/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.helper;

import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.cloud.api.process.model.QueryCloudSubprocessInstance;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.ProcessInstanceService;
import org.activiti.cloud.services.query.rest.payload.LinkProcessInstancesRequest;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ProcessInstanceControllerHelper {
    private final ProcessInstanceRepository processInstanceRepository;
    private final ProcessInstanceService processInstanceService;

    public ProcessInstanceControllerHelper(ProcessInstanceRepository processInstanceRepository, ProcessInstanceService processInstanceService) {
        this.processInstanceRepository = processInstanceRepository;
        this.processInstanceService = processInstanceService;
    }

    public Page<ProcessInstanceEntity> findAllProcessInstances(Predicate predicate, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.findAll(predicate, pageable);
        return this.mapAllSubprocesses(processInstances, pageable);
    }

    public Page<ProcessInstanceEntity> findAllProcessInstancesWithVariables(Predicate predicate, List<String> variableKeys, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.findAllWithVariables(predicate, variableKeys, pageable);
        return this.mapAllSubprocesses(processInstances, pageable);
    }

    public ProcessInstanceEntity findById(String processInstanceId) {
        ProcessInstanceEntity processInstance = this.processInstanceService.findById(processInstanceId);
        return this.processInstanceRepository.mapSubprocesses(processInstance);
    }

    public Page<ProcessInstanceEntity> searchProcessInstances(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.search(searchRequest, pageable);
        processInstances = this.mapAllSubprocesses(processInstances, pageable);
        return this.mapAllLinkedProcesses(processInstances);
    }

    public Page<ProcessInstanceEntity> searchSubprocesses(String processInstanceId, Predicate predicate, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstanceSubprocesses = this.processInstanceService.subprocesses(processInstanceId, predicate, pageable);
        return this.mapAllSubprocesses(processInstanceSubprocesses, pageable);
    }

    public Page<ProcessInstanceEntity> mapAllSubprocesses(Page<ProcessInstanceEntity> processInstances, Pageable pageable) {
        return this.processInstanceRepository.mapSubprocesses(processInstances, pageable);
    }

    public Long countProcessInstances(ProcessInstanceSearchRequest searchRequest) {
        return this.processInstanceService.count(searchRequest);
    }

    public Page<ProcessInstanceEntity> mapAllLinkedProcesses(Page<ProcessInstanceEntity> processInstances) {
        processInstances.getContent().forEach(processInstance -> {
            List<ProcessInstanceEntity> linkedProcesses = this.processInstanceService.searchLinkedProcesses(processInstance.getId());
            processInstance.setLinkedProcesses(ProcessInstanceControllerHelper.mapLinkedProcessEntities(linkedProcesses));
        });
        return processInstances;
    }

    public static Set<QueryCloudSubprocessInstance> mapLinkedProcessEntities(List<ProcessInstanceEntity> linkedProcesses) {
        if (linkedProcesses == null) {
            return Set.of();
        }
        return linkedProcesses.stream().map(lp -> {
            QueryCloudSubprocessInstance instance = new QueryCloudSubprocessInstance();
            instance.setId(lp.getId());
            instance.setProcessDefinitionName(lp.getProcessDefinitionName());
            return instance;
        }).collect(Collectors.toSet());
    }

    public void linkProcessInstances(LinkProcessInstancesRequest request, String mainProcessInstanceId) {
        this.processInstanceService.linkProcessInstances(mainProcessInstanceId, request.getProcessInstanceIds(), request.getLinkProcessInstanceType());
    }
}

