/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.ProcessModelRepository;
import org.activiti.cloud.services.query.model.ProcessModelEntity;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.springframework.data.repository.CrudRepository;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=ProcessModelEntity.class)
@RequestMapping(value={"/v1/process-definitions/{processDefinitionId}/model"})
public class ProcessModelController {
    private ProcessModelRepository processModelRepository;
    private EntityFinder entityFinder;
    private SecurityPoliciesManager securityPoliciesManager;

    public ProcessModelController(ProcessModelRepository processModelRepository, EntityFinder entityFinder, SecurityPoliciesManager securityPoliciesManager) {
        this.processModelRepository = processModelRepository;
        this.entityFinder = entityFinder;
        this.securityPoliciesManager = securityPoliciesManager;
    }

    @GetMapping(produces={"application/xml"})
    @ResponseBody
    public String getProcessModel(@PathVariable(value="processDefinitionId") String processDefinitionId) {
        ProcessModelEntity processModelEntity = (ProcessModelEntity)this.entityFinder.findById((CrudRepository)this.processModelRepository, (Object)processDefinitionId, "Unable to find process model for the given id:'" + processDefinitionId + "`");
        if (this.securityPoliciesManager.arePoliciesDefined() && !this.securityPoliciesManager.canRead(processModelEntity.getProcessDefinition().getKey(), processModelEntity.getProcessDefinition().getServiceName())) {
            throw new ActivitiForbiddenException("Operation not permitted for " + processModelEntity.getProcessDefinition().getKey());
        }
        return processModelEntity.getProcessModelContent();
    }
}

