/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.ArrayList;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"activiti.rest.enable-deletion"}, matchIfMissing=true)
@RestController
@RequestMapping(value={"/admin/v1/tasks"}, produces={"application/hal+json", "application/json"})
public class TaskDeleteController {
    private final TaskRepository taskRepository;
    private TaskRepresentationModelAssembler taskRepresentationModelAssembler;

    @Autowired
    public TaskDeleteController(TaskRepository taskRepository, TaskRepresentationModelAssembler taskRepresentationModelAssembler) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.DELETE})
    public CollectionModel<EntityModel<QueryCloudTask>> deleteTasks(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskEntity.class) Predicate predicate) {
        ArrayList<EntityModel<QueryCloudTask>> result = new ArrayList<EntityModel<QueryCloudTask>>();
        Iterable iterable = this.taskRepository.findAll(predicate);
        for (TaskEntity entity : iterable) {
            result.add(this.taskRepresentationModelAssembler.toModel(entity));
        }
        this.taskRepository.deleteAll(iterable);
        return CollectionModel.of(result);
    }
}

