/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.TaskControllerHelper;
import org.activiti.cloud.services.query.rest.VariableSearch;
import org.activiti.cloud.services.query.rest.advice.TaskControllerAdvice;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.activiti.cloud.services.query.rest.payload.TaskSearchRequest;
import org.activiti.cloud.services.query.rest.payload.TasksQueryBody;
import org.activiti.cloud.services.query.rest.predicate.RootTasksFilter;
import org.activiti.cloud.services.query.rest.predicate.StandAloneTaskFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/tasks"}, produces={"application/hal+json", "application/json"})
public class TaskAdminController
extends TaskControllerAdvice {
    private final TaskRepository taskRepository;
    private TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private EntityFinder entityFinder;
    private TaskControllerHelper taskControllerHelper;

    @Autowired
    public TaskAdminController(TaskRepository taskRepository, TaskRepresentationModelAssembler taskRepresentationModelAssembler, EntityFinder entityFinder, TaskControllerHelper taskControllerHelper) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.entityFinder = entityFinder;
        this.taskControllerHelper = taskControllerHelper;
    }

    @Operation(summary="Find tasks Admin", hidden=true)
    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.GET}, params={"!variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> findAllServiceTaskAdmin(@Parameter(description="Filter tasks without parent task.") @RequestParam(name="rootTasksOnly", defaultValue="false") Boolean rootTasksOnly, @Parameter(description="Filter tasks without parent process.") @RequestParam(name="standalone", defaultValue="false") Boolean standalone, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskEntity.class) Predicate predicate, VariableSearch variableSearch, Pageable pageable) {
        return this.taskControllerHelper.findAll(predicate, variableSearch, pageable, Arrays.asList(new RootTasksFilter(rootTasksOnly), new StandAloneTaskFilter(standalone)));
    }

    @Operation(summary="Find tasks with Process Variables Admin")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @RequestMapping(method={RequestMethod.GET}, params={"variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> findAllWithProcessVariablesAdmin(@Parameter(description="Filter tasks without parent task.") @RequestParam(name="rootTasksOnly", defaultValue="false") Boolean rootTasksOnly, @Parameter(description="Filter tasks without parent process.") @RequestParam(name="standalone", defaultValue="false") Boolean standalone, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskEntity.class) Predicate predicate, @Parameter(description="Used to retrieve process variables. It is constructed from process definition key and variable name, e.g.: {processDefinitionKey}/{variableName}.", example="Process_90W_3nLpw/initializedVar") @RequestParam(value="variableKeys", required=false, defaultValue="") List<String> processVariableKeys, VariableSearch variableSearch, Pageable pageable) {
        return this.taskControllerHelper.findAllWithProcessVariables(predicate, variableSearch, pageable, Arrays.asList(new RootTasksFilter(rootTasksOnly), new StandAloneTaskFilter(standalone)), processVariableKeys);
    }

    @Operation(summary="Search tasks")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/search"})
    public PagedModel<EntityModel<QueryCloudTask>> searchTasks(@RequestBody TaskSearchRequest taskSearchRequest, Pageable pageable) {
        return this.taskControllerHelper.searchTasksUnrestricted(taskSearchRequest, pageable);
    }

    @RequestMapping(method={RequestMethod.POST})
    public MappingJacksonValue findAllFromBodyTaskAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskEntity.class) Predicate predicate, @RequestBody(required=false) TasksQueryBody payload, VariableSearch variableSearch, Pageable pageable) {
        TasksQueryBody queryBody = Optional.ofNullable(payload).orElse(new TasksQueryBody());
        PagedModel<EntityModel<QueryCloudTask>> pagedModel = this.taskControllerHelper.findAllFromBody(predicate, variableSearch, pageable, Arrays.asList(new RootTasksFilter(queryBody.isRootTasksOnly()), new StandAloneTaskFilter(queryBody.isStandalone())), queryBody.getVariableKeys());
        MappingJacksonValue result = new MappingJacksonValue(pagedModel);
        if (queryBody.hasVariableKeys()) {
            result.setSerializationView(JsonViews.ProcessVariables.class);
        } else {
            result.setSerializationView(JsonViews.General.class);
        }
        return result;
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public EntityModel<QueryCloudTask> findByIdTaskAdmin(@PathVariable String taskId) {
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        return this.taskRepresentationModelAssembler.toModel(taskEntity);
    }

    @RequestMapping(value={"/{taskId}/candidate-users"}, method={RequestMethod.GET})
    public List<String> getTaskCandidateUsersAdmin(@PathVariable String taskId) {
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        return taskEntity.getTaskCandidateUsers() != null ? taskEntity.getTaskCandidateUsers().stream().map(TaskCandidateUserEntity::getUserId).collect(Collectors.toList()) : null;
    }

    @RequestMapping(value={"/{taskId}/candidate-groups"}, method={RequestMethod.GET})
    public List<String> getTaskCandidateGroupsAdmin(@PathVariable String taskId) {
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        return taskEntity.getTaskCandidateGroups() != null ? taskEntity.getTaskCandidateGroups().stream().map(TaskCandidateGroupEntity::getGroupId).collect(Collectors.toList()) : null;
    }

    @Operation(summary="Count tasks")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/count"})
    public Long countTasks(@RequestBody TaskSearchRequest taskSearchRequest) {
        return this.taskControllerHelper.countTasksUnrestricted(taskSearchRequest);
    }
}

