/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Optional;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudProcessDefinition;
import org.activiti.cloud.services.query.app.repository.ProcessDefinitionRepository;
import org.activiti.cloud.services.query.model.ProcessDefinitionEntity;
import org.activiti.cloud.services.query.rest.assembler.ProcessDefinitionRepresentationModelAssembler;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=ProcessDefinitionEntity.class)
@RequestMapping(value={"/admin/v1/process-definitions"}, produces={"application/hal+json", "application/json"})
public class ProcessDefinitionAdminController {
    private ProcessDefinitionRepository repository;
    private AlfrescoPagedModelAssembler<ProcessDefinitionEntity> pagedCollectionModelAssembler;
    private ProcessDefinitionRepresentationModelAssembler processDefinitionRepresentationModelAssembler;

    public ProcessDefinitionAdminController(ProcessDefinitionRepository repository, AlfrescoPagedModelAssembler<ProcessDefinitionEntity> pagedCollectionModelAssembler, ProcessDefinitionRepresentationModelAssembler processDefinitionRepresentationModelAssembler) {
        this.repository = repository;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processDefinitionRepresentationModelAssembler = processDefinitionRepresentationModelAssembler;
    }

    @Operation(summary="Find all Process Admin")
    @GetMapping
    public PagedModel<EntityModel<CloudProcessDefinition>> findAllProcessAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessDefinitionEntity.class) Predicate predicate, Pageable pageable) {
        predicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        return this.pagedCollectionModelAssembler.toModel(pageable, this.repository.findAll(predicate, pageable), (RepresentationModelAssembler)this.processDefinitionRepresentationModelAssembler);
    }
}

