/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.IntegrationContextRepository;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.rest.assembler.IntegrationContextRepresentationModelAssembler;
import org.springframework.data.repository.CrudRepository;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/service-tasks"}, produces={"application/hal+json", "application/json"})
public class ServiceTaskIntegrationContextAdminController {
    private final IntegrationContextRepository repository;
    private final IntegrationContextRepresentationModelAssembler representationModelAssembler;
    private final EntityFinder entityFinder;

    public ServiceTaskIntegrationContextAdminController(IntegrationContextRepository repository, IntegrationContextRepresentationModelAssembler representationModelAssembler, EntityFinder entityFinder) {
        this.repository = repository;
        this.representationModelAssembler = representationModelAssembler;
        this.entityFinder = entityFinder;
    }

    @RequestMapping(value={"/{serviceTaskId}/integration-context"}, method={RequestMethod.GET})
    public EntityModel<CloudIntegrationContext> findById(@PathVariable String serviceTaskId) {
        IntegrationContextEntity entity = (IntegrationContextEntity)this.entityFinder.findById((CrudRepository)this.repository, (Object)serviceTaskId, "Unable to find integration context entity for the given id:'" + serviceTaskId + "'");
        return this.representationModelAssembler.toModel(entity);
    }
}

