/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.TaskControllerHelper;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process-instances/{processInstanceId}"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceTasksController {
    private TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler;
    private TaskControllerHelper taskControllerHelper;
    private final TaskRepository taskRepository;

    @Autowired
    public ProcessInstanceTasksController(TaskRepository taskRepository, TaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler, TaskControllerHelper taskControllerHelper) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.taskControllerHelper = taskControllerHelper;
    }

    @Operation(summary="Find tasks for process instance")
    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/tasks"}, method={RequestMethod.GET}, params={"!variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> getTasks(@PathVariable String processInstanceId, Pageable pageable) {
        Predicate restrictedQuery = this.restrictQuery(processInstanceId);
        return this.taskControllerHelper.findAllByInvolvedUserQuery(restrictedQuery, pageable);
    }

    @Operation(summary="Find tasks for process instance")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @RequestMapping(value={"/tasks"}, method={RequestMethod.GET}, params={"variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> getTasksWithProcessVariables(@PathVariable String processInstanceId, @Parameter(description="Used to retrieve process variables. It is constructed from process definition key and variable name, e.g.: {processDefinitionKey}/{variableName}.", example="Process_90W_3nLpw/initializedVar") @RequestParam(value="variableKeys", required=false, defaultValue="") List<String> processVariableKeys, Pageable pageable) {
        Predicate restrictedQuery = this.restrictQuery(processInstanceId);
        return this.taskControllerHelper.findAllByInvolvedUserQueryWithProcessVariables(restrictedQuery, processVariableKeys, pageable);
    }

    private Predicate restrictQuery(String processInstanceId) {
        return QTaskEntity.taskEntity.processInstanceId.eq((Object)processInstanceId);
    }
}

