/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Set;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity_;
import org.activiti.cloud.services.query.model.ProcessVariableKey;
import org.springframework.data.jpa.domain.Specification;

public class ProcessVariableSpecification
implements Specification<ProcessVariableEntity> {
    private final Set<String> processInstanceIds;
    private final Set<ProcessVariableKey> processVariableKeys;

    public ProcessVariableSpecification(Set<String> processInstanceIds, Set<ProcessVariableKey> processVariableKeys) {
        this.processInstanceIds = processInstanceIds;
        this.processVariableKeys = processVariableKeys;
    }

    public Predicate toPredicate(Root<ProcessVariableEntity> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Predicate keyAndNameFilter = this.processVariableKeys.stream().map(processVariableKey -> {
            Path processVariableKeyExpression = root.get(ProcessVariableEntity_.processDefinitionKey);
            Path processVariableValueExpression = root.get(ProcessVariableEntity_.name);
            return criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)processVariableKeyExpression, (Object)processVariableKey.processDefinitionKey()), (Expression)criteriaBuilder.equal((Expression)processVariableValueExpression, (Object)processVariableKey.variableName()));
        }).reduce((arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).or(arg_0, arg_1)).orElse(criteriaBuilder.disjunction());
        return criteriaBuilder.and((Expression)root.get(ProcessVariableEntity_.processInstanceId).in(this.processInstanceIds), (Expression)keyAndNameFilter);
    }
}

