/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.util.Map;
import org.activiti.cloud.services.query.model.AbstractVariableEntity;
import org.activiti.cloud.services.query.rest.filter.FilterOperator;
import org.activiti.cloud.services.query.rest.filter.VariableFilter;
import org.activiti.cloud.services.query.rest.specification.VariableSelectionExpressionImpl;
import org.activiti.cloud.services.query.rest.specification.VariableValueFilterCondition;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

public class VariableValueFilterConditionImpl<R, K extends AbstractVariableEntity>
extends VariableSelectionExpressionImpl<R, K>
implements VariableValueFilterCondition {
    private final VariableFilter filter;

    protected VariableValueFilterConditionImpl(From<R, K> root, Map<Path<String>, String> selectionFilters, Class<?> variableJavaType, VariableFilter filter, CriteriaBuilder criteriaBuilder) {
        super(root, selectionFilters, variableJavaType, criteriaBuilder);
        this.filter = filter;
    }

    public VariableFilter getFilter() {
        return this.filter;
    }

    @Override
    public Predicate getPredicate() {
        try {
            return switch (this.filter.operator()) {
                default -> throw new MatchException(null, null);
                case FilterOperator.EQUALS -> this.criteriaBuilder.equal(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.NOT_EQUALS -> this.criteriaBuilder.notEqual(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.GREATER_THAN -> this.criteriaBuilder.greaterThan(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.GREATER_THAN_OR_EQUAL -> this.criteriaBuilder.greaterThanOrEqualTo(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.LESS_THAN -> this.criteriaBuilder.lessThan(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.LESS_THAN_OR_EQUAL -> this.criteriaBuilder.lessThanOrEqualTo(this.getSelectionExpression(), this.getConvertedFilterValue());
                case FilterOperator.LIKE -> this.criteriaBuilder.like(this.criteriaBuilder.lower(this.getSelectionExpression()), "%" + this.filter.value().toLowerCase() + "%");
            };
        }
        catch (IllegalArgumentException | FunctionArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Illegal filter for variable type %s. Operator: %s, value: %s".formatted(new Object[]{this.filter.type(), this.filter.operator(), this.filter.value()}));
        }
    }

    private Expression getConvertedFilterValue() {
        if (this.variableJavaType == Boolean.class) {
            return this.criteriaBuilder.literal((Object)(Boolean.parseBoolean(this.filter.value()) ? 1 : 0));
        }
        if (this.variableJavaType == BigDecimal.class) {
            return this.criteriaBuilder.literal((Object)new BigDecimal(this.filter.value()));
        }
        Expression value = this.criteriaBuilder.literal((Object)this.filter.value());
        return this.variableJavaType == String.class ? value : value.as(this.variableJavaType);
    }
}

