/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.querydsl.core.types.Predicate;
import org.activiti.cloud.services.security.ProcessDefinitionFilter;
import org.activiti.cloud.services.security.ProcessDefinitionKeyBasedRestrictionBuilder;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;

public class ProcessDefinitionRestrictionService {
    private SecurityPoliciesManager securityPoliciesManager;
    private ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder;
    private ProcessDefinitionFilter processDefinitionFilter;

    public ProcessDefinitionRestrictionService(SecurityPoliciesManager securityPoliciesManager, ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder, ProcessDefinitionFilter processDefinitionFilter) {
        this.securityPoliciesManager = securityPoliciesManager;
        this.restrictionBuilder = restrictionBuilder;
        this.processDefinitionFilter = processDefinitionFilter;
    }

    public Predicate restrictProcessDefinitionQuery(Predicate predicate, SecurityPolicyAccess securityPolicyAccess) {
        if (!this.securityPoliciesManager.arePoliciesDefined()) {
            return predicate;
        }
        return this.restrictionBuilder.applyProcessDefinitionKeyFilter(predicate, securityPolicyAccess, this.processDefinitionFilter);
    }
}

