/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import java.util.Set;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableKey;
import org.activiti.cloud.services.query.rest.ProcessVariableService;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.activiti.cloud.services.query.rest.specification.ProcessInstanceSpecification;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public class ProcessInstanceSearchService {
    private final ProcessInstanceRepository processInstanceRepository;
    private final ProcessVariableService processVariableService;
    private final SecurityManager securityManager;

    public ProcessInstanceSearchService(ProcessInstanceRepository processInstanceRepository, ProcessVariableService processVariableService, SecurityManager securityManager) {
        this.processInstanceRepository = processInstanceRepository;
        this.processVariableService = processVariableService;
        this.securityManager = securityManager;
    }

    @Transactional(readOnly=true)
    public Page<ProcessInstanceEntity> searchRestricted(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        return this.search(searchRequest.processVariableKeys(), pageable, ProcessInstanceSpecification.restricted(searchRequest, this.securityManager.getAuthenticatedUserId()));
    }

    @Transactional(readOnly=true)
    public Page<ProcessInstanceEntity> searchUnrestricted(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        return this.search(searchRequest.processVariableKeys(), pageable, ProcessInstanceSpecification.unrestricted(searchRequest));
    }

    private Page<ProcessInstanceEntity> search(Set<ProcessVariableKey> processVariableKeys, Pageable pageable, ProcessInstanceSpecification specification) {
        Page processInstances = this.processInstanceRepository.findAll((Specification)specification, pageable);
        this.processVariableService.fetchProcessVariablesForProcessInstances(processInstances.getContent(), processVariableKeys);
        return processInstances;
    }

    @Transactional(readOnly=true)
    public Long countRestricted(ProcessInstanceSearchRequest searchRequest) {
        ProcessInstanceSpecification restrictedSpecification = ProcessInstanceSpecification.restricted(searchRequest, this.securityManager.getAuthenticatedUserId());
        return this.processInstanceRepository.count((Specification)restrictedSpecification);
    }

    @Transactional(readOnly=true)
    public Long countUnrestricted(ProcessInstanceSearchRequest searchRequest) {
        ProcessInstanceSpecification unrestrictedSpecification = ProcessInstanceSpecification.unrestricted(searchRequest);
        return this.processInstanceRepository.count((Specification)unrestrictedSpecification);
    }
}

