/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Optional;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudApplication;
import org.activiti.cloud.services.query.app.repository.ApplicationRepository;
import org.activiti.cloud.services.query.model.ApplicationEntity;
import org.activiti.cloud.services.query.rest.assembler.ApplicationRepresentationModelAssembler;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=ApplicationEntity.class)
@RequestMapping(value={"/admin/v1/applications"}, produces={"application/hal+json", "application/json"})
public class ApplicationAdminController {
    private ApplicationRepository repository;
    private AlfrescoPagedModelAssembler<ApplicationEntity> pagedCollectionModelAssembler;
    private ApplicationRepresentationModelAssembler applicationRepresentationModelAssembler;

    public ApplicationAdminController(ApplicationRepository repository, AlfrescoPagedModelAssembler<ApplicationEntity> pagedCollectionModelAssembler, ApplicationRepresentationModelAssembler applicationRepresentationModelAssembler) {
        this.repository = repository;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.applicationRepresentationModelAssembler = applicationRepresentationModelAssembler;
    }

    @GetMapping
    public PagedModel<EntityModel<CloudApplication>> findAllApplicationAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ApplicationEntity.class) Predicate predicate, Pageable pageable) {
        predicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        return this.pagedCollectionModelAssembler.toModel(pageable, this.repository.findAll(predicate, pageable), (RepresentationModelAssembler)this.applicationRepresentationModelAssembler);
    }
}

