/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.advice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class TaskControllerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskControllerAdvice.class);

    @ExceptionHandler(value={InvalidDataAccessApiUsageException.class})
    public ResponseEntity<String> handleInvalidDataAccessApiUsageException(InvalidDataAccessApiUsageException e) {
        LOGGER.warn("Invalid data access in task search: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)String.format("Invalid search parameter: %s", e.getMessage()));
    }
}

