/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.dialect;

import java.math.BigDecimal;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.StandardBasicTypes;

public class CustomPostgreSQLDialect
extends PostgreSQLDialect {
    public static final String EXTRACT_JSON_STRING_VALUE = "jsonb_string_value_extract";
    public static final String EXTRACT_JSON_BOOLEAN_VALUE = "jsonb_boolean_value_extract";
    public static final String EXTRACT_JSON_NUMERIC_VALUE = "jsonb_numeric_value_extract";
    private static final Map<Class<?>, String> extractionFunctionsByType = Map.of(String.class, "jsonb_string_value_extract", Boolean.class, "jsonb_boolean_value_extract", BigDecimal.class, "jsonb_numeric_value_extract");

    public static String getExtractionFunctionName(Class<?> type) {
        return extractionFunctionsByType.getOrDefault(type, EXTRACT_JSON_STRING_VALUE);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.patternDescriptorBuilder(EXTRACT_JSON_STRING_VALUE, "?1->>'value'").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setExactArgumentCount(1).setArgumentListSignature("JSONB jsonb").register();
        functionRegistry.patternDescriptorBuilder(EXTRACT_JSON_BOOLEAN_VALUE, "(?1->>'value')::BOOLEAN").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN)).setExactArgumentCount(1).setArgumentListSignature("JSONB jsonb").register();
        functionRegistry.patternDescriptorBuilder(EXTRACT_JSON_NUMERIC_VALUE, "(?1->>'value')::NUMERIC(38,16)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BIG_DECIMAL)).setExactArgumentCount(1).setArgumentListSignature("JSONB jsonb").register();
    }
}

