/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.events.IntegrationEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.api.process.model.events.CloudIntegrationResultReceivedEvent;
import org.activiti.cloud.services.query.events.handlers.BaseIntegrationEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;

public class IntegrationResultReceivedEventHandler
extends BaseIntegrationEventHandler
implements QueryEventHandler {
    public IntegrationResultReceivedEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudIntegrationResultReceivedEvent integrationEvent = (CloudIntegrationResultReceivedEvent)CloudIntegrationResultReceivedEvent.class.cast(event);
        Optional<IntegrationContextEntity> result = this.findIntegrationContextEntity((CloudIntegrationEvent)integrationEvent);
        boolean isNewEntity = result.isEmpty();
        IntegrationContextEntity entity = result.orElseGet(() -> this.createMissingIntegrationContextEntity((CloudIntegrationEvent)integrationEvent));
        String serviceTaskId = IntegrationContextEntity.IdBuilderHelper.from((IntegrationContext)((IntegrationContext)integrationEvent.getEntity()));
        ServiceTaskEntity serviceTaskEntity = (ServiceTaskEntity)this.entityManager.find(ServiceTaskEntity.class, (Object)serviceTaskId);
        if (serviceTaskEntity != null && entity.getServiceTask() == null) {
            entity.setServiceTask(serviceTaskEntity);
            if (isNewEntity) {
                serviceTaskEntity.incrementIntegrationContextCounter();
            }
        }
        entity.setResultDate(new Date(integrationEvent.getTimestamp()));
        entity.setStatus(CloudIntegrationContext.IntegrationContextStatus.INTEGRATION_RESULT_RECEIVED);
        entity.setOutBoundVariables(((IntegrationContext)integrationEvent.getEntity()).getOutBoundVariables());
        this.entityManager.persist((Object)entity);
    }

    @Override
    public String getHandledEvent() {
        return IntegrationEvent.IntegrationEvents.INTEGRATION_RESULT_RECEIVED.name();
    }
}

