/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCompletedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;

public class TaskCompletedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskCompletedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCompletedEvent taskCompletedEvent = (CloudTaskCompletedEvent)event;
        Task eventTask = (Task)taskCompletedEvent.getEntity();
        Optional<TaskEntity> findResult = Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)eventTask.getId()));
        TaskEntity queryTaskEntity = findResult.orElseThrow(() -> new QueryException("Unable to find task with id: " + eventTask.getId()));
        queryTaskEntity.setStatus(eventTask.getStatus());
        queryTaskEntity.setLastModified(new Date(taskCompletedEvent.getTimestamp()));
        queryTaskEntity.setCompletedDate(new Date(taskCompletedEvent.getTimestamp()));
        queryTaskEntity.setCompletedBy(((Task)taskCompletedEvent.getEntity()).getCompletedBy());
        if (queryTaskEntity.getCompletedDate() != null && queryTaskEntity.getCreatedDate() != null) {
            queryTaskEntity.setDuration(queryTaskEntity.getCompletedDate().getTime() - queryTaskEntity.getCreatedDate().getTime());
        }
        this.entityManager.persist((Object)queryTaskEntity);
    }

    @Override
    public String getHandledEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_COMPLETED.name();
    }
}

