/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCreatedEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCreatedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCreatedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public TaskCreatedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCreatedEvent taskCreatedEvent = (CloudTaskCreatedEvent)CloudTaskCreatedEvent.class.cast(event);
        String taskId = ((Task)taskCreatedEvent.getEntity()).getId();
        Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)taskId)).ifPresentOrElse(taskEntity -> LOGGER.warn("Task instance entity already exists for: " + taskId + "!"), () -> {
            TaskEntity queryTaskEntity = new TaskEntity(taskCreatedEvent);
            if (!queryTaskEntity.isStandalone()) {
                this.entityManagerFinder.findProcessInstanceWithTasks(queryTaskEntity.getProcessInstanceId()).ifPresentOrElse(processInstanceEntity -> {
                    queryTaskEntity.setProcessInstance(processInstanceEntity);
                    queryTaskEntity.setProcessDefinitionName(processInstanceEntity.getProcessDefinitionName());
                    queryTaskEntity.setProcessVariables(processInstanceEntity.getVariables());
                    queryTaskEntity.setRootProcessInstanceId(processInstanceEntity.getRootProcessInstanceId());
                    processInstanceEntity.getTasks().add(queryTaskEntity);
                }, () -> {
                    throw new QueryException("Unable to find task process instance with id: " + queryTaskEntity.getProcessInstanceId());
                });
            }
            this.persistIntoDatabase(event, queryTaskEntity);
        });
    }

    private void persistIntoDatabase(CloudRuntimeEvent<?, ?> event, TaskEntity queryTaskEntity) {
        try {
            this.entityManager.persist((Object)queryTaskEntity);
        }
        catch (Exception cause) {
            throw new QueryException("Error handling TaskCreatedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_CREATED.name();
    }
}

