/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessResumedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessResumedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessResumedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessResumedEvent processResumedEvent = (CloudProcessResumedEvent)event;
        String processInstanceId = ((ProcessInstance)processResumedEvent.getEntity()).getId();
        Optional<ProcessInstanceEntity> findResult = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId));
        ProcessInstanceEntity processInstanceEntity = findResult.orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + processInstanceId));
        processInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.RUNNING);
        processInstanceEntity.setLastModified(new Date(processResumedEvent.getTimestamp()));
        this.entityManager.persist((Object)processInstanceEntity);
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_RESUMED.name();
    }
}

