/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import org.activiti.api.model.shared.event.VariableEvent;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableDeletedEvent;
import org.activiti.cloud.services.query.events.handlers.ProcessVariableDeletedEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.events.handlers.TaskVariableDeletedEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableDeletedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableDeletedEventHandler.class);
    private final ProcessVariableDeletedEventHandler processVariableDeletedHandler;
    private final TaskVariableDeletedEventHandler taskVariableDeletedEventHandler;

    public VariableDeletedEventHandler(ProcessVariableDeletedEventHandler processVariableDeletedHandler, TaskVariableDeletedEventHandler taskVariableDeletedEventHandler) {
        this.processVariableDeletedHandler = processVariableDeletedHandler;
        this.taskVariableDeletedEventHandler = taskVariableDeletedEventHandler;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudVariableDeletedEvent variableDeletedEvent = (CloudVariableDeletedEvent)event;
        try {
            if (((VariableInstance)variableDeletedEvent.getEntity()).isTaskVariable()) {
                this.taskVariableDeletedEventHandler.handle(variableDeletedEvent);
            } else {
                this.processVariableDeletedHandler.handle(variableDeletedEvent);
            }
        }
        catch (Exception cause) {
            LOGGER.debug("Error handling VariableDeletedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return VariableEvent.VariableEvents.VARIABLE_DELETED.name();
    }
}

