/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskActivatedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;

public class TaskActivatedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskActivatedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskActivatedEvent taskActivatedEvent = (CloudTaskActivatedEvent)event;
        Task eventTask = (Task)taskActivatedEvent.getEntity();
        Optional<TaskEntity> findResult = Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)eventTask.getId()));
        TaskEntity taskEntity = findResult.orElseThrow(() -> new QueryException("Unable to find taskEntity with id: " + eventTask.getId()));
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().isEmpty()) {
            taskEntity.setStatus(Task.TaskStatus.ASSIGNED);
        } else {
            taskEntity.setStatus(Task.TaskStatus.CREATED);
        }
        taskEntity.setLastModified(new Date(taskActivatedEvent.getTimestamp()));
        taskEntity.setOwner(((Task)taskActivatedEvent.getEntity()).getOwner());
        taskEntity.setClaimedDate(((Task)taskActivatedEvent.getEntity()).getClaimedDate());
        this.entityManager.persist((Object)taskEntity);
    }

    @Override
    public String getHandledEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_ACTIVATED.name();
    }
}

